"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CustomDashboardListGatewayApiImpl = void 0;
var apis_1 = require("../apis");
var CustomDashboardListGatewayApiImpl = (function () {
    function CustomDashboardListGatewayApiImpl() {
        var _this = this;
        this._CustomDashboardFilter = {
            customDashboardNames: []
        };
        this.listeners = [];
        this.getCustomDashboardFilter = function () {
            return Promise.resolve(_this._CustomDashboardFilter);
        };
        this.applyFilter = function (customDashboardFilter) {
            _this._CustomDashboardFilter = customDashboardFilter;
            return Promise.resolve();
        };
        this.openDashboard = function (customDashboardInfo) {
            _this.listeners.forEach(function (listener) { return listener.onOpen(customDashboardInfo); });
            return Promise.resolve();
        };
    }
    CustomDashboardListGatewayApiImpl.prototype.getCustomDashboardsQuery = function () {
        return (0, apis_1.getCustomDashboard)(this._CustomDashboardFilter.customDashboardNames);
    };
    CustomDashboardListGatewayApiImpl.prototype.onOpenCustomDashboardListen = function (listener) {
        var _this = this;
        this.listeners.push(listener);
        var unSubscribe = function () {
            var index = _this.listeners.indexOf(listener);
            if (index > -1) {
                _this.listeners.splice(index, 1);
            }
        };
        return {
            unSubscribe: unSubscribe
        };
    };
    return CustomDashboardListGatewayApiImpl;
}());
exports.CustomDashboardListGatewayApiImpl = CustomDashboardListGatewayApiImpl;
//# sourceMappingURL=CustomDashboardListGatewayApi.js.map