/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.api;

import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Objects;
import org.kie.kogito.codegen.api.GeneratedFileType;

public class GeneratedFile {
    private final String relativePath;
    private final byte[] contents;
    private final GeneratedFileType type;

    public GeneratedFile(GeneratedFileType type, Path relativePath, String contents) {
        this(type, relativePath, contents.getBytes(StandardCharsets.UTF_8));
    }

    public GeneratedFile(GeneratedFileType type, Path relativePath, byte[] contents) {
        this(type, relativePath.toString(), contents);
    }

    public GeneratedFile(GeneratedFileType type, String relativePath, String contents) {
        this(type, relativePath, contents.getBytes(StandardCharsets.UTF_8));
    }

    public GeneratedFile(GeneratedFileType type, String relativePath, byte[] contents) {
        this.type = type;
        this.relativePath = relativePath;
        this.contents = contents;
    }

    public String relativePath() {
        return this.relativePath;
    }

    public byte[] contents() {
        return this.contents;
    }

    public GeneratedFileType type() {
        return this.type;
    }

    public GeneratedFileType.Category category() {
        return this.type.category();
    }

    public String toString() {
        return "GeneratedFile{type=" + this.type + ", relativePath='" + this.relativePath + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeneratedFile that = (GeneratedFile)o;
        return Objects.equals(this.relativePath, that.relativePath);
    }

    public int hashCode() {
        return Objects.hash(this.relativePath);
    }
}

