/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.api.context;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.drools.codegen.common.AppPaths;
import org.drools.codegen.common.DroolsModelBuildContext;
import org.kie.kogito.KogitoGAV;
import org.kie.kogito.codegen.api.AddonsConfig;
import org.kie.kogito.codegen.api.ApplicationSection;
import org.kie.kogito.codegen.api.Generator;
import org.kie.kogito.codegen.api.SourceFileCodegenBindNotifier;
import org.kie.kogito.codegen.api.context.KogitoApplicationPropertyProvider;
import org.kie.kogito.codegen.api.di.DependencyInjectionAnnotator;
import org.kie.kogito.codegen.api.rest.RestAnnotator;

public interface KogitoBuildContext
extends DroolsModelBuildContext {
    public static String generateRESTConfigurationKeyForResource(String generatorType) {
        return String.format("%s.%s", "kogito.generate.rest", generatorType);
    }

    public boolean hasClassAvailable(String var1);

    public boolean hasImplementationClassAvailable(Class<?> var1);

    public DependencyInjectionAnnotator getDependencyInjectionAnnotator();

    public void setDependencyInjectionAnnotator(DependencyInjectionAnnotator var1);

    default public boolean hasDI() {
        return this.getDependencyInjectionAnnotator() != null && "true".equalsIgnoreCase(this.getApplicationProperty("kogito.generate.di").orElse("true"));
    }

    public RestAnnotator getRestAnnotator();

    public void setRestAnnotator(RestAnnotator var1);

    public Set<ApplicationSection> getApplicationSections();

    public void addAllApplicationSections(Set<ApplicationSection> var1);

    public void addApplicationSection(ApplicationSection var1);

    default public boolean hasRESTForGenerator(Generator generator) {
        return this.hasRESTGloballyAvailable() && "true".equalsIgnoreCase(this.getApplicationProperty(KogitoBuildContext.generateRESTConfigurationKeyForResource(generator.name())).orElse("true"));
    }

    default public boolean hasRESTGloballyAvailable() {
        return this.getRestAnnotator() != null && "true".equalsIgnoreCase(this.getApplicationProperty("kogito.generate.rest").orElse("true"));
    }

    default public boolean isValidationSupported() {
        return this.hasClassAvailable("javax.validation.constraints.NotNull");
    }

    default public boolean isOpenApiSpecSupported() {
        return this.hasClassAvailable("org.eclipse.microprofile.openapi.annotations.media.Schema");
    }

    public <T> Optional<T> getApplicationProperty(String var1, Class<T> var2);

    public AddonsConfig getAddonsConfig();

    public Map<String, Object> getContextAttributes();

    public void addContextAttribute(String var1, Object var2);

    public <T> T getContextAttribute(String var1, Class<T> var2);

    public Optional<KogitoGAV> getGAV();

    public Optional<SourceFileCodegenBindNotifier> getSourceFileCodegenBindNotifier();

    default public Map<String, String> getPropertiesMap() {
        return this.getApplicationProperties().stream().filter(key -> this.getApplicationProperty((String)key).isPresent()).collect(Collectors.toUnmodifiableMap(key -> key, key -> (String)this.getApplicationProperty((String)key).get()));
    }

    default public Collection<String> getGeneratedHandlers() {
        return Collections.emptySet();
    }

    default public void addGeneratedHandler(String workName) {
    }

    public static interface Builder {
        public Builder withPackageName(String var1);

        public Builder withApplicationPropertyProvider(KogitoApplicationPropertyProvider var1);

        public Builder withApplicationProperties(Properties var1);

        public Builder withApplicationProperties(File ... var1);

        public Builder withAddonsConfig(AddonsConfig var1);

        public Builder withClassAvailabilityResolver(Predicate<String> var1);

        public Builder withClassSubTypeAvailabilityResolver(Predicate<Class<?>> var1);

        public Builder withClassLoader(ClassLoader var1);

        public Builder withAppPaths(AppPaths var1);

        public Builder withGAV(KogitoGAV var1);

        public Builder withSourceFileProcessBindNotifier(SourceFileCodegenBindNotifier var1);

        public KogitoBuildContext build();
    }
}

