/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.task.management;

import java.util.List;
import org.kie.kogito.process.ProcessConfig;
import org.kie.kogito.process.Processes;
import org.kie.kogito.process.workitem.Policies;
import org.kie.kogito.task.management.service.TaskInfo;
import org.kie.kogito.task.management.service.TaskManagementOperations;
import org.kie.kogito.task.management.service.TaskManagementService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/management/processes"})
public class TaskManagementRestController {
    TaskManagementOperations taskService;

    @Autowired
    public TaskManagementRestController(Processes processes, ProcessConfig processConfig) {
        this.taskService = new TaskManagementService(processes, processConfig);
    }

    @PutMapping(value={"{processId}/instances/{processInstanceId}/tasks/{taskId}"}, produces={"application/json"})
    public ResponseEntity<Void> updateTask(@PathVariable(value="processId") String processId, @PathVariable(value="processInstanceId") String processInstanceId, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody TaskInfo taskInfo) {
        this.taskService.updateTask(processId, processInstanceId, taskId, taskInfo, true, Policies.of((String)user, groups));
        return ResponseEntity.ok().build();
    }

    @PatchMapping(value={"{processId}/instances/{processInstanceId}/tasks/{taskId}"}, produces={"application/json"})
    public TaskInfo partialUpdateTask(@PathVariable(value="processId") String processId, @PathVariable(value="processInstanceId") String processInstanceId, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody TaskInfo taskInfo) {
        return this.taskService.updateTask(processId, processInstanceId, taskId, taskInfo, false, Policies.of((String)user, groups));
    }

    @GetMapping(value={"{processId}/instances/{processInstanceId}/tasks/{taskId}"}, produces={"application/json"})
    public TaskInfo getTask(@PathVariable(value="processId") String processId, @PathVariable(value="processInstanceId") String processInstanceId, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return this.taskService.getTask(processId, processInstanceId, taskId, Policies.of((String)user, groups));
    }
}

