/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.serverless.workflow.python;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemHandler;
import org.kie.kogito.process.impl.CachedWorkItemHandlerConfig;
import org.kie.kogito.serverless.workflow.python.PythonScriptWorkItemHandler;
import org.kie.kogito.serverless.workflow.python.PythonServiceWorkItemHandler;

@ApplicationScoped
public class PythonWorkItemHandlerConfig
extends CachedWorkItemHandlerConfig {
    private PythonScriptWorkItemHandler scriptHandler;
    private PythonServiceWorkItemHandler serviceHandler;

    @PostConstruct
    void init() {
        this.scriptHandler = this.registerHandler(new PythonScriptWorkItemHandler());
        this.serviceHandler = this.registerHandler(new PythonServiceWorkItemHandler());
    }

    @PreDestroy
    void cleanup() {
        this.scriptHandler.close();
        this.serviceHandler.close();
    }

    private <T extends KogitoWorkItemHandler> T registerHandler(T handler) {
        this.register(handler.getName(), handler);
        return handler;
    }
}

