/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.grafana;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.kie.dmn.model.api.Decision;
import org.kie.kogito.grafana.JGrafana;
import org.kie.kogito.grafana.dmn.SupportedDecisionTypes;
import org.kie.kogito.grafana.model.panel.PanelType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrafanaConfigurationWriter {
    private static final Logger logger = LoggerFactory.getLogger(GrafanaConfigurationWriter.class);
    private static final String AUDIT_LINK_NAME = "Audit UI";
    private static final String AUDIT_LINK_URL_PLACEHOLDER = "${{urlPlaceholder}}";

    private GrafanaConfigurationWriter() {
    }

    public static String generateOperationalDashboard(String templatePath, String handlerName, boolean generateAuditLink) {
        JGrafana jgrafana;
        String template = GrafanaConfigurationWriter.readStandardDashboard(templatePath);
        template = GrafanaConfigurationWriter.customizeTemplate(template, handlerName);
        try {
            jgrafana = JGrafana.parse(template).setTitle(String.format("%s - Operational Dashboard", handlerName));
        }
        catch (IOException e) {
            logger.error(String.format("Could not parse the grafana template for the endpoint %s", handlerName), (Throwable)e);
            throw new IllegalArgumentException("Could not parse the dashboard template.", e);
        }
        if (generateAuditLink) {
            jgrafana.addLink(AUDIT_LINK_NAME, AUDIT_LINK_URL_PLACEHOLDER);
        }
        try {
            return jgrafana.serialize();
        }
        catch (IOException e) {
            logger.error(String.format("Could not serialize the grafana dashboard for the endpoint %s", handlerName), (Throwable)e);
            throw new RuntimeException("Could not serialize the grafana dashboard.", e);
        }
    }

    public static String generateDomainSpecificDMNDashboard(String templatePath, String endpoint, List<Decision> decisions, boolean generateAuditLink) {
        String template = GrafanaConfigurationWriter.readStandardDashboard(templatePath);
        template = GrafanaConfigurationWriter.customizeTemplate(template, endpoint);
        JGrafana jgrafana = null;
        try {
            jgrafana = JGrafana.parse(template).setTitle(String.format("%s - Domain Dashboard", endpoint));
        }
        catch (IOException e) {
            logger.error(String.format("Could not parse the grafana template for the endpoint %s", endpoint), (Throwable)e);
            throw new IllegalArgumentException("Could not parse the dashboard template.", e);
        }
        if (generateAuditLink) {
            jgrafana.addLink(AUDIT_LINK_NAME, AUDIT_LINK_URL_PLACEHOLDER);
        }
        for (Decision decision : decisions) {
            QName type = decision.getVariable().getTypeRef();
            if (type == null) {
                logger.warn(String.format("DMN typeref for the decision \"%s\" with node id \"%s\" is null.", decision.getName(), decision.getId()));
                continue;
            }
            if (!SupportedDecisionTypes.isSupported(type.getLocalPart())) continue;
            jgrafana.addPanel(PanelType.GRAPH, "Decision " + decision.getName(), String.format("%s_dmn_result{endpoint = \"%s\", decision = \"%s\"}", type.toString().replace(" ", "_"), endpoint, decision.getName()), SupportedDecisionTypes.getGrafanaFunction(type.getLocalPart()), SupportedDecisionTypes.getYAxis(type.getLocalPart()));
        }
        try {
            return jgrafana.serialize();
        }
        catch (IOException e) {
            logger.error(String.format("Could not serialize the grafana dashboard for the endpoint %s", endpoint), (Throwable)e);
            throw new RuntimeException("Could not serialize the grafana dashboard.", e);
        }
    }

    private static String readStandardDashboard(String templatePath) {
        InputStream is = GrafanaConfigurationWriter.class.getResourceAsStream(templatePath);
        return new BufferedReader(new InputStreamReader(is)).lines().collect(Collectors.joining("\n"));
    }

    private static String customizeTemplate(String template, String handlerName) {
        template = template.replaceAll("\\$handlerName\\$", handlerName);
        template = template.replaceAll("\\$id\\$", String.valueOf(new Random().nextInt()));
        template = template.replaceAll("\\$uid\\$", UUID.randomUUID().toString());
        return template;
    }
}

