/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.models;

import java.util.Map;
import org.kie.kogito.explainability.api.BaseExplainabilityRequestDto;
import org.kie.kogito.explainability.api.LIMEExplainabilityRequestDto;
import org.kie.kogito.explainability.models.ModelIdentifier;
import org.kie.kogito.tracing.typedvalue.TypedValue;

public class ExplainabilityRequest {
    private final String executionId;
    private final String serviceUrl;
    private final ModelIdentifier modelIdentifier;
    private final Map<String, TypedValue> inputs;
    private final Map<String, TypedValue> outputs;

    private ExplainabilityRequest(String executionId, String serviceUrl, ModelIdentifier modelIdentifier, Map<String, TypedValue> inputs, Map<String, TypedValue> outputs) {
        this.executionId = executionId;
        this.serviceUrl = serviceUrl;
        this.modelIdentifier = modelIdentifier;
        this.inputs = inputs;
        this.outputs = outputs;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public ModelIdentifier getModelIdentifier() {
        return this.modelIdentifier;
    }

    public Map<String, TypedValue> getInputs() {
        return this.inputs;
    }

    public Map<String, TypedValue> getOutputs() {
        return this.outputs;
    }

    public static ExplainabilityRequest from(BaseExplainabilityRequestDto dto) {
        if (dto instanceof LIMEExplainabilityRequestDto) {
            return new ExplainabilityRequest(dto.getExecutionId(), dto.getServiceUrl(), ModelIdentifier.from(dto.getModelIdentifier()), dto.getInputs(), dto.getOutputs());
        }
        throw new IllegalArgumentException(String.format("Explainability result for '%s' is not supported", dto.getClass().getName()));
    }
}

