/*
 * Copyright 2020 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.kogito.explainability;

import io.vertx.mutiny.core.Vertx;
import org.eclipse.microprofile.context.ManagedExecutor;
import org.eclipse.microprofile.context.ThreadContext;
import org.kie.kogito.explainability.model.PredictionProvider;
import org.kie.kogito.explainability.models.ExplainabilityRequest;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class PredictionProviderFactoryImpl implements PredictionProviderFactory {

    private final Vertx vertx;
    private final ThreadContext threadContext;
    private final ManagedExecutor managedExecutor;

    @Inject
    public PredictionProviderFactoryImpl(
            Vertx vertx,
            ThreadContext threadContext,
            ManagedExecutor managedExecutor) {

        this.vertx = vertx;
        this.threadContext = threadContext;
        this.managedExecutor = managedExecutor;
    }

    @Override
    public PredictionProvider createPredictionProvider(ExplainabilityRequest request) {
        return new RemotePredictionProvider(request, vertx, threadContext, managedExecutor);
    }
}
