/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.examples.onboarding;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jbpm.process.instance.impl.humantask.HumanTaskTransition;
import org.jbpm.util.JsonSchemaUtil;
import org.kie.kogito.Application;
import org.kie.kogito.MapOutput;
import org.kie.kogito.examples.onboarding.OnboardingModel;
import org.kie.kogito.examples.onboarding.OnboardingModelInput;
import org.kie.kogito.examples.onboarding.OnboardingModelOutput;
import org.kie.kogito.examples.onboarding.Onboarding_3_TaskInput;
import org.kie.kogito.examples.onboarding.Onboarding_3_TaskOutput;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceReadMode;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.workitem.Policies;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.process.workitem.Transition;
import org.kie.kogito.services.uow.UnitOfWorkExecutor;
import org.kie.kogito.uow.UnitOfWorkManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Path(value="/onboarding")
@Component
public class OnboardingResource {
    @Autowired
    @Qualifier(value="onboarding.onboarding")
    Process<OnboardingModel> process;
    @Autowired
    Application application;

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response createResource_onboarding(@Context HttpHeaders httpHeaders, @Context UriInfo uriInfo, @QueryParam(value="businessKey") String businessKey, @Valid @NotNull OnboardingModelInput resource) {
        return (Response)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            OnboardingModelInput inputModel = resource != null ? resource : new OnboardingModelInput();
            ProcessInstance pi = this.process.createInstance(businessKey, (Object)inputModel.toModel());
            String startFromNode = httpHeaders.getHeaderString("X-KOGITO-StartFromNode");
            if (startFromNode != null) {
                pi.startFrom(startFromNode);
            } else {
                pi.start();
            }
            UriBuilder uriBuilder = uriInfo.getAbsolutePathBuilder().path(pi.id());
            return Response.created((URI)uriBuilder.build(new Object[0])).entity((Object)((OnboardingModel)pi.checkError().variables()).toOutput()).build();
        });
    }

    @GET
    @Produces(value={"application/json"})
    public List<OnboardingModelOutput> getResources_onboarding() {
        return this.process.instances().values().stream().map(pi -> ((OnboardingModel)pi.variables()).toOutput()).collect(Collectors.toList());
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public OnboardingModelOutput getResource_onboarding(@PathParam(value="id") String id) {
        return this.process.instances().findById(id, ProcessInstanceReadMode.READ_ONLY).map(pi -> ((OnboardingModel)pi.variables()).toOutput()).orElseThrow(() -> new NotFoundException());
    }

    @DELETE
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public OnboardingModelOutput deleteResource_onboarding(@PathParam(value="id") String id) {
        return (OnboardingModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.abort();
            return ((OnboardingModel)pi.checkError().variables()).toOutput();
        }).orElseThrow(() -> new NotFoundException()));
    }

    @PUT
    @Path(value="/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OnboardingModelOutput updateModel_onboarding(@PathParam(value="id") String id, OnboardingModel resource) {
        return (OnboardingModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> ((OnboardingModel)pi.updateVariables((Object)resource)).toOutput()).orElseThrow(() -> new NotFoundException()));
    }

    @GET
    @Path(value="/{id}/tasks")
    @Produces(value={"application/json"})
    public List<WorkItem> getTasks_onboarding(@PathParam(value="id") String id, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups) {
        return this.process.instances().findById(id, ProcessInstanceReadMode.READ_ONLY).map(pi -> pi.workItems(Policies.of((String)user, (Collection)groups))).orElseThrow(() -> new NotFoundException());
    }

    @POST
    @Path(value="/{id}/ManagerConfirmation/{workItemId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OnboardingModelOutput completeTask_ManagerConfirmation_0(@PathParam(value="id") String id, @PathParam(value="workItemId") String workItemId, @QueryParam(value="phase") @DefaultValue(value="complete") String phase, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups, Onboarding_3_TaskOutput model) {
        return (OnboardingModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(workItemId, (Transition)HumanTaskTransition.withModel((String)phase, (MapOutput)model, (Policy[])Policies.of((String)user, (Collection)groups)));
            return ((OnboardingModel)pi.variables()).toOutput();
        }).orElseThrow(() -> new NotFoundException()));
    }

    @GET
    @Path(value="/{id}/ManagerConfirmation/{workItemId}")
    @Produces(value={"application/json"})
    public Onboarding_3_TaskInput getTask_ManagerConfirmation_0(@PathParam(value="id") String id, @PathParam(value="workItemId") String workItemId, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups) {
        return this.process.instances().findById(id, ProcessInstanceReadMode.READ_ONLY).map(pi -> Onboarding_3_TaskInput.from((WorkItem)pi.workItem(workItemId, Policies.of((String)user, (Collection)groups)))).orElseThrow(() -> new NotFoundException());
    }

    @GET
    @Path(value="ManagerConfirmation/schema")
    @Produces(value={"application/json"})
    public Map<String, Object> getSchema_ManagerConfirmation_0() {
        return JsonSchemaUtil.load((ClassLoader)this.getClass().getClassLoader(), (String)this.process.id(), (String)"ManagerConfirmation");
    }

    @GET
    @Path(value="/{id}/ManagerConfirmation/{workItemId}/schema")
    @Produces(value={"application/json"})
    public Map<String, Object> getSchemaAndPhases_ManagerConfirmation_0(@PathParam(value="id") String id, @PathParam(value="workItemId") String workItemId, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups) {
        return JsonSchemaUtil.addPhases((Process)this.process, (Application)this.application, (String)id, (String)workItemId, (Policy[])Policies.of((String)user, groups), (Map)JsonSchemaUtil.load((ClassLoader)this.getClass().getClassLoader(), (String)this.process.id(), (String)"ManagerConfirmation"));
    }

    @DELETE
    @Path(value="/{id}/ManagerConfirmation/{workItemId}")
    @Produces(value={"application/json"})
    public OnboardingModelOutput abortTask_ManagerConfirmation_0(@PathParam(value="id") String id, @PathParam(value="workItemId") String workItemId, @QueryParam(value="phase") @DefaultValue(value="abort") String phase, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups) {
        return (OnboardingModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(workItemId, (Transition)HumanTaskTransition.withoutModel((String)phase, (Policy[])Policies.of((String)user, (Collection)groups)));
            return ((OnboardingModel)pi.variables()).toOutput();
        }).orElseThrow(() -> new NotFoundException()));
    }
}

