/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.examples.onboarding;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import org.jbpm.process.instance.impl.humantask.HumanTaskTransition;
import org.jbpm.util.JsonSchemaUtil;
import org.kie.api.runtime.process.WorkItemNotFoundException;
import org.kie.kogito.Application;
import org.kie.kogito.auth.IdentityProvider;
import org.kie.kogito.auth.SecurityPolicy;
import org.kie.kogito.examples.onboarding.OnboardingModel;
import org.kie.kogito.examples.onboarding.OnboardingModelInput;
import org.kie.kogito.examples.onboarding.OnboardingModelOutput;
import org.kie.kogito.examples.onboarding.Onboarding_3_TaskInput;
import org.kie.kogito.examples.onboarding.Onboarding_3_TaskOutput;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessError;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceExecutionException;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.process.workitem.Transition;
import org.kie.kogito.services.identity.StaticIdentityProvider;
import org.kie.kogito.services.uow.UnitOfWorkExecutor;
import org.kie.kogito.uow.UnitOfWorkManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Path(value="/onboarding")
@Component
public class OnboardingResource {
    @Autowired
    @Qualifier(value="onboarding.onboarding")
    Process<OnboardingModel> process;
    @Autowired
    Application application;

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public OnboardingModelOutput createResource_onboarding(@Context HttpHeaders httpHeaders, @QueryParam(value="businessKey") String businessKey, @Valid @NotNull OnboardingModelInput resource) {
        if (resource == null) {
            resource = new OnboardingModelInput();
        }
        OnboardingModelInput value = resource;
        return (OnboardingModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            ProcessInstance pi = this.process.createInstance(businessKey, (Object)this.mapInput(value, new OnboardingModel()));
            String startFromNode = httpHeaders.getHeaderString("X-KOGITO-StartFromNode");
            if (startFromNode != null) {
                pi.startFrom(startFromNode);
            } else {
                pi.start();
            }
            return this.getModel(pi);
        });
    }

    @GET
    @Produces(value={"application/json"})
    public List<OnboardingModelOutput> getResources_onboarding() {
        return this.process.instances().values().stream().map(pi -> this.mapOutput(new OnboardingModelOutput(), (OnboardingModel)pi.variables())).collect(Collectors.toList());
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public OnboardingModelOutput getResource_onboarding(@PathParam(value="id") String id) {
        return this.process.instances().findById(id).map(pi -> this.mapOutput(new OnboardingModelOutput(), (OnboardingModel)pi.variables())).orElse(null);
    }

    @DELETE
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public OnboardingModelOutput deleteResource_onboarding(@PathParam(value="id") String id) {
        return (OnboardingModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            ProcessInstance pi = this.process.instances().findById(id).orElse(null);
            if (pi == null) {
                return null;
            }
            pi.abort();
            return this.getModel(pi);
        });
    }

    @POST
    @Path(value="/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OnboardingModelOutput updateModel_onboarding(@PathParam(value="id") String id, OnboardingModel resource) {
        return (OnboardingModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            ProcessInstance pi = this.process.instances().findById(id).orElse(null);
            if (pi == null) {
                return null;
            }
            pi.updateVariables((Object)resource);
            return this.mapOutput(new OnboardingModelOutput(), (OnboardingModel)pi.variables());
        });
    }

    @GET
    @Path(value="/{id}/tasks")
    @Produces(value={"application/json"})
    public Map<String, String> getTasks_onboarding(@PathParam(value="id") String id, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups) {
        return this.process.instances().findById(id).map(pi -> pi.workItems(this.policies(user, groups))).map(l -> l.stream().collect(Collectors.toMap(WorkItem::getId, WorkItem::getName))).orElse(null);
    }

    protected OnboardingModelOutput getModel(ProcessInstance<OnboardingModel> pi) {
        if (pi.status() == 5 && pi.error().isPresent()) {
            throw new ProcessInstanceExecutionException(pi.id(), ((ProcessError)pi.error().get()).failedNodeId(), ((ProcessError)pi.error().get()).errorMessage());
        }
        return this.mapOutput(new OnboardingModelOutput(), (OnboardingModel)pi.variables());
    }

    protected Policy[] policies(String user, List<String> groups) {
        if (user == null) {
            return new Policy[0];
        }
        StaticIdentityProvider identity = null;
        if (user != null) {
            identity = new StaticIdentityProvider(user, groups);
        }
        return new Policy[]{SecurityPolicy.of((IdentityProvider)identity)};
    }

    protected OnboardingModel mapInput(@Valid @NotNull OnboardingModelInput input, OnboardingModel resource) {
        resource.fromMap(input.toMap());
        return resource;
    }

    protected OnboardingModelOutput mapOutput(OnboardingModelOutput output, OnboardingModel resource) {
        output.fromMap(resource.getId(), resource.toMap());
        return output;
    }

    @POST
    @Path(value="/{id}/ManagerConfirmation/{workItemId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OnboardingModelOutput completeTask_ManagerConfirmation_0(@PathParam(value="id") String id, @PathParam(value="workItemId") String workItemId, @QueryParam(value="phase") @DefaultValue(value="complete") String phase, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups, Onboarding_3_TaskOutput model) {
        try {
            return (OnboardingModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
                ProcessInstance pi = this.process.instances().findById(id).orElse(null);
                if (pi == null) {
                    return null;
                }
                StaticIdentityProvider identity = null;
                if (user != null) {
                    identity = new StaticIdentityProvider(user, groups);
                }
                HumanTaskTransition transition = new HumanTaskTransition(phase, model.toMap(), (IdentityProvider)identity);
                pi.transitionWorkItem(workItemId, (Transition)transition);
                return this.getModel(pi);
            });
        }
        catch (WorkItemNotFoundException e) {
            return null;
        }
    }

    @GET
    @Path(value="/{id}/ManagerConfirmation/{workItemId}")
    @Produces(value={"application/json"})
    public Onboarding_3_TaskInput getTask_ManagerConfirmation_0(@PathParam(value="id") String id, @PathParam(value="workItemId") String workItemId, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups) {
        try {
            ProcessInstance pi = this.process.instances().findById(id).orElse(null);
            if (pi == null) {
                return null;
            }
            WorkItem workItem = pi.workItem(workItemId, this.policies(user, groups));
            if (workItem == null) {
                return null;
            }
            return Onboarding_3_TaskInput.fromMap((String)workItem.getId(), (String)workItem.getName(), (Map)workItem.getParameters());
        }
        catch (WorkItemNotFoundException e) {
            return null;
        }
    }

    @GET
    @Path(value="ManagerConfirmation/schema")
    @Produces(value={"application/json"})
    public Map<String, Object> getSchema_ManagerConfirmation_0() {
        return JsonSchemaUtil.load((ClassLoader)this.getClass().getClassLoader(), (String)this.process.id(), (String)"ManagerConfirmation");
    }

    @GET
    @Path(value="/{id}/ManagerConfirmation/{workItemId}/schema")
    @Produces(value={"application/json"})
    public Map<String, Object> getSchemaAndPhases_ManagerConfirmation_0(@PathParam(value="id") String id, @PathParam(value="workItemId") String workItemId, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups) {
        return JsonSchemaUtil.addPhases((Process)this.process, (Application)this.application, (String)id, (String)workItemId, (Policy[])this.policies(user, groups), (Map)JsonSchemaUtil.load((ClassLoader)this.getClass().getClassLoader(), (String)this.process.id(), (String)"ManagerConfirmation"));
    }

    @DELETE
    @Path(value="/{id}/ManagerConfirmation/{workItemId}")
    @Produces(value={"application/json"})
    public OnboardingModelOutput abortTask_ManagerConfirmation_0(@PathParam(value="id") String id, @PathParam(value="workItemId") String workItemId, @QueryParam(value="phase") @DefaultValue(value="abort") String phase, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups) {
        try {
            return (OnboardingModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
                ProcessInstance pi = this.process.instances().findById(id).orElse(null);
                if (pi == null) {
                    return null;
                }
                StaticIdentityProvider identity = null;
                if (user != null) {
                    identity = new StaticIdentityProvider(user, groups);
                }
                HumanTaskTransition transition = new HumanTaskTransition(phase, null, (IdentityProvider)identity);
                pi.transitionWorkItem(workItemId, (Transition)transition);
                return this.getModel(pi);
            });
        }
        catch (WorkItemNotFoundException e) {
            return null;
        }
    }
}

