/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.examples.demo;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.kie.api.runtime.process.WorkItemNotFoundException;
import org.kie.kogito.Application;
import org.kie.kogito.examples.demo.PersonsModel;
import org.kie.kogito.examples.demo.Persons_4_TaskInput;
import org.kie.kogito.examples.demo.Persons_4_TaskOutput;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessError;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceExecutionException;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.services.uow.UnitOfWorkExecutor;
import org.kie.kogito.uow.UnitOfWorkManager;

@Path(value="/persons")
public class PersonsResource {
    @Inject
    @Named(value="persons")
    Process<PersonsModel> process;
    @Inject
    Application application;

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public PersonsModel createResource_persons(PersonsModel resource) {
        if (resource == null) {
            resource = new PersonsModel();
        }
        PersonsModel value = resource;
        return (PersonsModel)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            ProcessInstance pi = this.process.createInstance((Object)value);
            pi.start();
            return this.getModel((ProcessInstance<PersonsModel>)pi);
        });
    }

    @GET
    @Produces(value={"application/json"})
    public List<PersonsModel> getResources_persons() {
        return this.process.instances().values().stream().map(ProcessInstance::variables).collect(Collectors.toList());
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public PersonsModel getResource_persons(@PathParam(value="id") String id) {
        return this.process.instances().findById(id).map(ProcessInstance::variables).orElse(null);
    }

    @DELETE
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public PersonsModel deleteResource_persons(@PathParam(value="id") String id) {
        return (PersonsModel)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            ProcessInstance pi = this.process.instances().findById(id).orElse(null);
            if (pi == null) {
                return null;
            }
            pi.abort();
            return this.getModel((ProcessInstance<PersonsModel>)pi);
        });
    }

    @POST
    @Path(value="/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public PersonsModel updateModel_persons(@PathParam(value="id") String id, PersonsModel resource) {
        return (PersonsModel)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            ProcessInstance pi = this.process.instances().findById(id).orElse(null);
            if (pi == null) {
                return null;
            }
            pi.updateVariables((Object)resource);
            return (PersonsModel)pi.variables();
        });
    }

    @GET
    @Path(value="/{id}/tasks")
    @Produces(value={"application/json"})
    public Map<String, String> getTasks_persons(@PathParam(value="id") String id) {
        return this.process.instances().findById(id).map(ProcessInstance::workItems).map(l -> l.stream().collect(Collectors.toMap(WorkItem::getId, WorkItem::getName))).orElse(null);
    }

    protected PersonsModel getModel(ProcessInstance<PersonsModel> pi) {
        if (pi.status() == 5 && pi.error().isPresent()) {
            throw new ProcessInstanceExecutionException(pi.id(), ((ProcessError)pi.error().get()).failedNodeId(), ((ProcessError)pi.error().get()).errorMessage());
        }
        return (PersonsModel)pi.variables();
    }

    @POST
    @Path(value="/{id}/ChildrenHandling/{workItemId}")
    @Produces(value={"application/json"})
    public PersonsModel completeTask_4(@PathParam(value="id") String id, @PathParam(value="workItemId") String workItemId, Persons_4_TaskOutput model) {
        try {
            return (PersonsModel)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
                ProcessInstance pi = this.process.instances().findById(id).orElse(null);
                if (pi == null) {
                    return null;
                }
                pi.completeWorkItem(workItemId, model.toMap());
                return this.getModel((ProcessInstance<PersonsModel>)pi);
            });
        }
        catch (WorkItemNotFoundException e) {
            return null;
        }
    }

    @GET
    @Path(value="/{id}/ChildrenHandling/{workItemId}")
    @Produces(value={"application/json"})
    public Persons_4_TaskInput getTask_4(@PathParam(value="id") String id, @PathParam(value="workItemId") String workItemId) {
        try {
            ProcessInstance pi = this.process.instances().findById(id).orElse(null);
            if (pi == null) {
                return null;
            }
            WorkItem workItem = pi.workItem(workItemId);
            if (workItem == null) {
                return null;
            }
            return Persons_4_TaskInput.fromMap(workItem.getId(), workItem.getName(), workItem.getParameters());
        }
        catch (WorkItemNotFoundException e) {
            return null;
        }
    }

    @DELETE
    @Path(value="/{id}/ChildrenHandling/{workItemId}")
    @Produces(value={"application/json"})
    public PersonsModel abortTask_4(@PathParam(value="id") String id, @PathParam(value="workItemId") String workItemId) {
        try {
            return (PersonsModel)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
                ProcessInstance pi = this.process.instances().findById(id).orElse(null);
                if (pi == null) {
                    return null;
                }
                pi.abortWorkItem(workItemId);
                return this.getModel((ProcessInstance<PersonsModel>)pi);
            });
        }
        catch (WorkItemNotFoundException e) {
            return null;
        }
    }
}

