/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.examples;

import java.util.Arrays;
import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.drools.project.model.ProjectRuntime;
import org.kie.kogito.Config;
import org.kie.kogito.Model;
import org.kie.kogito.event.EventPublisher;
import org.kie.kogito.examples.OrderItemsProcess;
import org.kie.kogito.examples.OrdersProcess;
import org.kie.kogito.examples.demo.PersonsProcess;
import org.kie.kogito.process.Process;
import org.kie.kogito.rules.KieRuntimeBuilder;
import org.kie.kogito.uow.UnitOfWorkManager;

@Singleton
public class Application
implements org.kie.kogito.Application {
    @Inject
    Instance<EventPublisher> eventPublishers;
    @Inject
    Config config;
    RuleUnits ruleUnits = new RuleUnits();
    Processes processes = new Processes();

    public Config config() {
        return this.config;
    }

    public UnitOfWorkManager unitOfWorkManager() {
        return this.config().process().unitOfWorkManager();
    }

    @PostConstruct
    public void setup() {
        if (this.eventPublishers != null) {
            this.eventPublishers.forEach(publisher -> this.unitOfWorkManager().eventManager().addPublisher(publisher));
        }
    }

    public RuleUnits ruleUnits() {
        return this.ruleUnits;
    }

    public Processes processes() {
        return this.processes;
    }

    public class Processes
    implements org.kie.kogito.process.Processes {
        public Process<? extends Model> processById(String processId) {
            if ("persons".equals(processId)) {
                return this.createPersonsProcess();
            }
            if ("demo.orderItems".equals(processId)) {
                return this.createOrderItemsProcess();
            }
            if ("demo.orders".equals(processId)) {
                return this.createOrdersProcess();
            }
            return null;
        }

        public Collection<String> processIds() {
            return Arrays.asList("persons", "demo.orderItems", "demo.orders");
        }

        public PersonsProcess createPersonsProcess() {
            return new PersonsProcess(Application.this).configure();
        }

        public OrderItemsProcess createOrderItemsProcess() {
            return new OrderItemsProcess(Application.this).configure();
        }

        public OrdersProcess createOrdersProcess() {
            return new OrdersProcess(Application.this).configure();
        }
    }

    public class RuleUnits
    implements org.kie.kogito.rules.RuleUnits {
        KieRuntimeBuilder ruleRuntimeBuilder = new ProjectRuntime();

        public KieRuntimeBuilder ruleRuntimeBuilder() {
            return this.ruleRuntimeBuilder;
        }
    }
}

