/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.examples.demo;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.kie.api.runtime.process.WorkItemNotFoundException;
import org.kie.kogito.examples.demo.PersonsModel;
import org.kie.kogito.examples.demo.Persons_4_TaskInput;
import org.kie.kogito.examples.demo.Persons_4_TaskOutput;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.WorkItem;

@Path(value="/persons")
public class PersonsResource {
    @Inject
    @Named(value="persons")
    Process<PersonsModel> process;

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public PersonsModel createResource_persons(PersonsModel resource) {
        if (resource == null) {
            resource = new PersonsModel();
        }
        ProcessInstance pi = this.process.createInstance((Object)resource);
        pi.start();
        return (PersonsModel)pi.variables();
    }

    @GET
    @Produces(value={"application/json"})
    public List<PersonsModel> getResources_persons() {
        return this.process.instances().values().stream().map(ProcessInstance::variables).collect(Collectors.toList());
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public PersonsModel getResource_persons(@PathParam(value="id") Long id) {
        return this.process.instances().findById(id.longValue()).map(ProcessInstance::variables).orElse(null);
    }

    @DELETE
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public PersonsModel deleteResource_persons(@PathParam(value="id") Long id) {
        ProcessInstance pi = this.process.instances().findById(id.longValue()).orElse(null);
        if (pi == null) {
            return null;
        }
        pi.abort();
        return (PersonsModel)pi.variables();
    }

    @GET
    @Path(value="/{id}/tasks")
    @Produces(value={"application/json"})
    public Map<Long, String> getTasks_persons(@PathParam(value="id") Long id) {
        return this.process.instances().findById(id.longValue()).map(ProcessInstance::workItems).map(l -> l.stream().collect(Collectors.toMap(WorkItem::getId, WorkItem::getName))).orElse(null);
    }

    @POST
    @Path(value="/{id}/ChildrenHandling/{workItemId}")
    @Produces(value={"application/json"})
    public PersonsModel completeTask_4(@PathParam(value="id") Long id, @PathParam(value="workItemId") Long workItemId, Persons_4_TaskOutput model) {
        try {
            ProcessInstance pi = this.process.instances().findById(id.longValue()).orElse(null);
            if (pi == null) {
                return null;
            }
            pi.completeWorkItem(workItemId.longValue(), model.toMap());
            return (PersonsModel)pi.variables();
        }
        catch (WorkItemNotFoundException e) {
            return null;
        }
    }

    @GET
    @Path(value="/{id}/ChildrenHandling/{workItemId}")
    @Produces(value={"application/json"})
    public Persons_4_TaskInput getTask_4(@PathParam(value="id") Long id, @PathParam(value="workItemId") Long workItemId) {
        try {
            ProcessInstance pi = this.process.instances().findById(id.longValue()).orElse(null);
            if (pi == null) {
                return null;
            }
            WorkItem workItem = pi.workItem(workItemId);
            if (workItem == null) {
                return null;
            }
            return Persons_4_TaskInput.fromMap(workItem.getId(), workItem.getName(), workItem.getParameters());
        }
        catch (WorkItemNotFoundException e) {
            return null;
        }
    }

    @DELETE
    @Path(value="/{id}/ChildrenHandling/{workItemId}")
    @Produces(value={"application/json"})
    public PersonsModel abortTask_4(@PathParam(value="id") Long id, @PathParam(value="workItemId") Long workItemId) {
        try {
            ProcessInstance pi = this.process.instances().findById(id.longValue()).orElse(null);
            if (pi == null) {
                return null;
            }
            pi.abortWorkItem(workItemId.longValue());
            return (PersonsModel)pi.variables();
        }
        catch (WorkItemNotFoundException e) {
            return null;
        }
    }
}

