/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.examples.demo;

import javax.annotation.PostConstruct;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jbpm.process.core.datatype.DataType;
import org.jbpm.process.core.datatype.impl.type.ObjectDataType;
import org.jbpm.ruleflow.core.RuleFlowProcessFactory;
import org.jbpm.ruleflow.core.factory.EndNodeFactory;
import org.jbpm.ruleflow.core.factory.HumanTaskNodeFactory;
import org.jbpm.ruleflow.core.factory.RuleSetNodeFactory;
import org.jbpm.ruleflow.core.factory.SplitFactory;
import org.jbpm.ruleflow.core.factory.StartNodeFactory;
import org.kie.api.definition.process.Process;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.kogito.Model;
import org.kie.kogito.examples.Application;
import org.kie.kogito.examples.demo.Person;
import org.kie.kogito.examples.demo.PersonsModel;
import org.kie.kogito.examples.demo.PersonsProcessInstance;
import org.kie.kogito.process.impl.AbstractProcess;

@Singleton
@Named(value="persons")
public class PersonsProcess
extends AbstractProcess<PersonsModel> {
    @Inject
    Instance<WorkItemHandler> handlers;
    Application app;

    public PersonsProcess() {
        this(new Application());
    }

    public PersonsProcess(Application app) {
        super(app.config().process());
        this.app = app;
    }

    public PersonsProcessInstance createInstance(PersonsModel value) {
        return new PersonsProcessInstance(this, value, this.createLegacyProcessRuntime());
    }

    public PersonsModel createModel() {
        return new PersonsModel();
    }

    public PersonsProcessInstance createInstance(Model value) {
        return this.createInstance((PersonsModel)value);
    }

    public PersonsProcess configure() {
        return this;
    }

    protected Process legacyProcess() {
        RuleFlowProcessFactory factory = RuleFlowProcessFactory.createProcess((String)"persons");
        factory.variable("person", (DataType)new ObjectDataType("org.kie.kogito.examples.demo.Person"));
        factory.name("Person Process");
        factory.packageName("org.kie.kogito.examples.demo");
        factory.dynamic(false);
        factory.version("1.0");
        factory.visibility("Public");
        factory.metaData("TargetNamespace", (Object)"http://www.omg.org/bpmn20");
        factory.imports(new String[]{"org.kie.kogito.examples.demo.Person"});
        StartNodeFactory startNode1 = factory.startNode(1L);
        startNode1.name("StartProcess");
        startNode1.done();
        RuleSetNodeFactory ruleSetNode2 = factory.ruleSetNode(2L);
        ruleSetNode2.name("Evaluate person");
        ruleSetNode2.ruleFlowGroup("person", () -> this.app.ruleUnits().ruleRuntimeBuilder().newKieSession("defaultStatelessKieSession", this.app.config().rule()));
        ruleSetNode2.inMapping("person", "person");
        ruleSetNode2.outMapping("person", "person");
        ruleSetNode2.done();
        SplitFactory splitNode3 = factory.splitNode(3L);
        splitNode3.name("Exclusive Gateway 1");
        splitNode3.type(2);
        splitNode3.metaData("UniqueId", (Object)"ExclusiveGateway_1");
        splitNode3.metaData("x", (Object)365);
        splitNode3.metaData("width", (Object)50);
        splitNode3.metaData("y", (Object)103);
        splitNode3.metaData("height", (Object)50);
        splitNode3.constraint(4L, "SequenceFlow_3", "DROOLS_DEFAULT", "java", kcontext -> {
            Person person = (Person)kcontext.getVariable("person");
            return !person.isAdult();
        }, 1);
        splitNode3.constraint(6L, "SequenceFlow_5", "DROOLS_DEFAULT", "java", kcontext -> {
            Person person = (Person)kcontext.getVariable("person");
            return person.isAdult();
        }, 1);
        splitNode3.done();
        HumanTaskNodeFactory humanTaskNode4 = factory.humanTaskNode(4L);
        humanTaskNode4.name("Special handling for children");
        humanTaskNode4.workParameter("Locale", (Object)"en-UK");
        humanTaskNode4.workParameter("TaskName", (Object)"ChildrenHandling");
        humanTaskNode4.workParameter("NodeName", (Object)"Special handling for children");
        humanTaskNode4.workParameter("Priority", (Object)"1");
        humanTaskNode4.workParameter("Skippable", (Object)"true");
        humanTaskNode4.inMapping("person", "person");
        humanTaskNode4.done();
        humanTaskNode4.metaData("UniqueId", (Object)"UserTask_1");
        humanTaskNode4.metaData("elementname", (Object)"Special handling for children");
        humanTaskNode4.metaData("x", (Object)465);
        humanTaskNode4.metaData("width", (Object)110);
        humanTaskNode4.metaData("y", (Object)105);
        humanTaskNode4.metaData("height", (Object)50);
        EndNodeFactory endNode5 = factory.endNode(5L);
        endNode5.name("End Event 1");
        endNode5.terminate(false);
        endNode5.done();
        EndNodeFactory endNode6 = factory.endNode(6L);
        endNode6.name("End Event 2");
        endNode6.terminate(false);
        endNode6.done();
        factory.connection(1L, 2L, "SequenceFlow_1");
        factory.connection(2L, 3L, "SequenceFlow_2");
        factory.connection(3L, 4L, "SequenceFlow_3");
        factory.connection(4L, 5L, "SequenceFlow_4");
        factory.connection(3L, 6L, "SequenceFlow_5");
        factory.validate();
        return factory.getProcess();
    }

    @PostConstruct
    public void init() {
        this.configure();
    }
}

