package org.kie.kogito.examples.demo;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import org.kie.api.runtime.process.WorkItemNotFoundException;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.examples.demo.PersonsModel;

@Path("/persons")
public class PersonsResource {

    @javax.inject.Inject()
    @javax.inject.Named("persons")
    Process<PersonsModel> process;

    @POST()
    @Produces(MediaType.APPLICATION_JSON)
    @Consumes(MediaType.APPLICATION_JSON)
    public PersonsModel createResource_persons(PersonsModel resource) {
        if (resource == null) {
            resource = new PersonsModel();
        }
        ProcessInstance<PersonsModel> pi = process.createInstance(resource);
        pi.start();
        return pi.variables();
    }

    @GET()
    @Produces(MediaType.APPLICATION_JSON)
    public List<PersonsModel> getResources_persons() {
        return process.instances().values().stream().map(ProcessInstance::variables).collect(Collectors.toList());
    }

    @GET()
    @Path("/{id}")
    @Produces(MediaType.APPLICATION_JSON)
    public PersonsModel getResource_persons(@PathParam("id") Long id) {
        return process.instances().findById(id).map(ProcessInstance::variables).orElse(null);
    }

    @DELETE()
    @Path("/{id}")
    @Produces(MediaType.APPLICATION_JSON)
    public PersonsModel deleteResource_persons(@PathParam("id") Long id) {
        ProcessInstance<PersonsModel> pi = process.instances().findById(id).orElse(null);
        if (pi == null) {
            return null;
        } else {
            pi.abort();
            return pi.variables();
        }
    }

    @GET()
    @Path("/{id}/tasks")
    @Produces(MediaType.APPLICATION_JSON)
    public Map<Long, String> getTasks_persons(@PathParam("id") Long id) {
        return process.instances().findById(id).map(ProcessInstance::workItems).map(l -> l.stream().collect(Collectors.toMap(WorkItem::getId, WorkItem::getName))).orElse(null);
    }

    @POST()
    @Path("/{id}/ChildrenHandling/{workItemId}")
    @Produces(MediaType.APPLICATION_JSON)
    public PersonsModel completeTask_4(@PathParam("id") Long id, @PathParam("workItemId") Long workItemId, Persons_4_TaskOutput model) {
        try {
            ProcessInstance<PersonsModel> pi = process.instances().findById(id).orElse(null);
            if (pi == null) {
                return null;
            } else {
                pi.completeWorkItem(workItemId, model.toMap());
                return pi.variables();
            }
        } catch (WorkItemNotFoundException e) {
            return null;
        }
    }

    @GET()
    @Path("/{id}/ChildrenHandling/{workItemId}")
    @Produces(MediaType.APPLICATION_JSON)
    public Persons_4_TaskInput getTask_4(@PathParam("id") Long id, @PathParam("workItemId") Long workItemId) {
        try {
            ProcessInstance<PersonsModel> pi = process.instances().findById(id).orElse(null);
            if (pi == null) {
                return null;
            } else {
                WorkItem workItem = pi.workItem(workItemId);
                if (workItem == null) {
                    return null;
                }
                return Persons_4_TaskInput.fromMap(workItem.getId(), workItem.getName(), workItem.getParameters());
            }
        } catch (WorkItemNotFoundException e) {
            return null;
        }
    }

    @DELETE()
    @Path("/{id}/ChildrenHandling/{workItemId}")
    @Produces(MediaType.APPLICATION_JSON)
    public PersonsModel abortTask_4(@PathParam("id") Long id, @PathParam("workItemId") Long workItemId) {
        try {
            ProcessInstance<PersonsModel> pi = process.instances().findById(id).orElse(null);
            if (pi == null) {
                return null;
            } else {
                pi.abortWorkItem(workItemId);
                return pi.variables();
            }
        } catch (WorkItemNotFoundException e) {
            return null;
        }
    }
}
