/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.examples;

import javax.annotation.PostConstruct;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jbpm.process.core.datatype.DataType;
import org.jbpm.process.core.datatype.impl.type.ObjectDataType;
import org.jbpm.ruleflow.core.RuleFlowProcessFactory;
import org.jbpm.ruleflow.core.factory.EndNodeFactory;
import org.jbpm.ruleflow.core.factory.HumanTaskNodeFactory;
import org.jbpm.ruleflow.core.factory.StartNodeFactory;
import org.jbpm.ruleflow.core.factory.WorkItemNodeFactory;
import org.kie.api.definition.process.Process;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.kogito.Model;
import org.kie.kogito.examples.Application;
import org.kie.kogito.examples.OrderItemsModel;
import org.kie.kogito.examples.OrderItemsProcessInstance;
import org.kie.kogito.process.impl.AbstractProcess;

@Singleton
@Named(value="demo.orderItems")
public class OrderItemsProcess
extends AbstractProcess<OrderItemsModel> {
    @Inject
    Instance<WorkItemHandler> handlers;
    Application app;

    public OrderItemsProcess() {
        this(new Application());
    }

    public OrderItemsProcess(Application app) {
        super(app.config().process());
        this.app = app;
    }

    public OrderItemsProcessInstance createInstance(OrderItemsModel value) {
        return new OrderItemsProcessInstance(this, value, this.createLegacyProcessRuntime());
    }

    public OrderItemsModel createModel() {
        return new OrderItemsModel();
    }

    public OrderItemsProcessInstance createInstance(Model value) {
        return this.createInstance((OrderItemsModel)value);
    }

    public OrderItemsProcess configure() {
        this.handlers.forEach(h -> this.services.getWorkItemManager().registerWorkItemHandler(h.getName(), h));
        return this;
    }

    protected Process legacyProcess() {
        RuleFlowProcessFactory factory = RuleFlowProcessFactory.createProcess((String)"demo.orderItems");
        factory.variable("order", (DataType)new ObjectDataType("org.kie.kogito.examples.demo.Order"));
        factory.variable("item", (DataType)new ObjectDataType("java.lang.String"));
        factory.name("orderItems");
        factory.packageName("org.kie.kogito.examples");
        factory.dynamic(false);
        factory.version("1.0");
        factory.visibility("Private");
        factory.metaData("TargetNamespace", (Object)"http://www.omg.org/bpmn20");
        factory.imports(new String[]{"org.kie.kogito.examples.demo.Order"});
        StartNodeFactory startNode1 = factory.startNode(1L);
        startNode1.name("Start");
        startNode1.done();
        EndNodeFactory endNode2 = factory.endNode(2L);
        endNode2.name("End");
        endNode2.terminate(false);
        endNode2.done();
        WorkItemNodeFactory workItemNode3 = factory.workItemNode(3L);
        workItemNode3.name("Calculate total");
        workItemNode3.workName("org.kie.kogito.examples.CalculationService.calculateTotal");
        workItemNode3.workParameter("ParameterType", (Object)"org.kie.kogito.examples.demo.Order");
        workItemNode3.workParameter("interfaceImplementationRef", (Object)"org.kie.kogito.examples.CalculationService");
        workItemNode3.workParameter("implementation", (Object)"java");
        workItemNode3.workParameter("Operation", (Object)"calculateTotal");
        workItemNode3.workParameter("Interface", (Object)"org.kie.kogito.examples.CalculationService");
        workItemNode3.inMapping("Parameter", "order");
        workItemNode3.outMapping("Result", "order");
        workItemNode3.done();
        HumanTaskNodeFactory humanTaskNode4 = factory.humanTaskNode(4L);
        humanTaskNode4.name("Verify order");
        humanTaskNode4.workParameter("Locale", (Object)"en-UK");
        humanTaskNode4.workParameter("TaskName", (Object)"Verify order");
        humanTaskNode4.workParameter("NodeName", (Object)"Verify order");
        humanTaskNode4.workParameter("Priority", (Object)"1");
        humanTaskNode4.workParameter("Skippable", (Object)"true");
        humanTaskNode4.workParameter("ActorId", (Object)"john");
        humanTaskNode4.inMapping("input1", "order");
        humanTaskNode4.done();
        factory.connection(4L, 2L, "SequenceFlow_4");
        factory.connection(1L, 3L, "SequenceFlow_1");
        factory.connection(3L, 4L, "SequenceFlow_3");
        factory.validate();
        return factory.getProcess();
    }

    @PostConstruct
    public void init() {
        this.configure();
    }
}

