/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.examples;

import javax.annotation.PostConstruct;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jbpm.process.core.datatype.DataType;
import org.jbpm.process.core.datatype.impl.type.ObjectDataType;
import org.jbpm.ruleflow.core.RuleFlowProcessFactory;
import org.jbpm.ruleflow.core.factory.ActionNodeFactory;
import org.jbpm.ruleflow.core.factory.EndNodeFactory;
import org.jbpm.ruleflow.core.factory.StartNodeFactory;
import org.jbpm.ruleflow.core.factory.SubProcessNodeFactory;
import org.jbpm.workflow.core.node.SubProcessFactory;
import org.kie.api.definition.process.Process;
import org.kie.api.runtime.process.ProcessContext;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.kogito.Model;
import org.kie.kogito.examples.Application;
import org.kie.kogito.examples.OrderItemsModel;
import org.kie.kogito.examples.OrdersModel;
import org.kie.kogito.examples.OrdersProcessInstance;
import org.kie.kogito.examples.demo.Order;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.impl.AbstractProcess;

@Singleton
@Named(value="demo.orders")
public class OrdersProcess
extends AbstractProcess<OrdersModel> {
    @Inject
    Instance<WorkItemHandler> handlers;
    Application app;
    @Inject
    org.kie.kogito.process.Process<OrderItemsModel> processorderItems;

    public OrdersProcess() {
        this(new Application());
    }

    public OrdersProcess(Application app) {
        super(app.config().process());
        this.app = app;
    }

    public OrdersProcessInstance createInstance(OrdersModel value) {
        return new OrdersProcessInstance(this, value, this.createLegacyProcessRuntime());
    }

    public OrdersModel createModel() {
        return new OrdersModel();
    }

    public OrdersProcessInstance createInstance(Model value) {
        return this.createInstance((OrdersModel)value);
    }

    public OrdersProcess configure() {
        return this;
    }

    protected Process legacyProcess() {
        RuleFlowProcessFactory factory = RuleFlowProcessFactory.createProcess((String)"demo.orders");
        factory.variable("order", (DataType)new ObjectDataType("org.kie.kogito.examples.demo.Order"));
        factory.variable("approver", (DataType)new ObjectDataType("java.lang.String"));
        factory.name("orders");
        factory.packageName("org.kie.kogito.examples");
        factory.dynamic(false);
        factory.version("1.0");
        factory.visibility("Public");
        factory.metaData("Documentation", (Object)"Deals with orders created by customer");
        factory.metaData("TargetNamespace", (Object)"http://www.omg.org/bpmn20");
        ActionNodeFactory actionNode1 = factory.actionNode(1L);
        actionNode1.name("Dump order");
        actionNode1.action(kcontext -> {
            Order order = (Order)kcontext.getVariable("order");
            String approver = (String)kcontext.getVariable("approver");
            System.out.println("Order has been created " + order + " with assigned approver " + approver);
        });
        actionNode1.done();
        EndNodeFactory endNode2 = factory.endNode(2L);
        endNode2.name("End");
        endNode2.terminate(false);
        endNode2.done();
        SubProcessNodeFactory subProcessNode3 = factory.subProcessNode(3L);
        subProcessNode3.name("Add items");
        subProcessNode3.processId("demo.orderItems");
        subProcessNode3.processName("");
        subProcessNode3.waitForCompletion(true);
        subProcessNode3.independent(false);
        subProcessNode3.subProcessFactory((SubProcessFactory)new SubProcessFactory<OrderItemsModel>(){

            public OrderItemsModel bind(ProcessContext kcontext) {
                OrderItemsModel model = new OrderItemsModel();
                Order order = (Order)kcontext.getVariable("order");
                model.setOrder(order);
                return model;
            }

            public ProcessInstance<OrderItemsModel> createInstance(OrderItemsModel model) {
                return OrdersProcess.this.processorderItems.createInstance((Object)model);
            }

            public void unbind(ProcessContext kcontext, OrderItemsModel model) {
                Order order = model.getOrder();
                kcontext.setVariable("order", (Object)order);
            }
        });
        subProcessNode3.done();
        StartNodeFactory startNode4 = factory.startNode(4L);
        startNode4.name("Start");
        startNode4.done();
        factory.connection(4L, 1L, "_B7B4282B-F317-4BF9-95E9-962B046EE815");
        factory.connection(3L, 2L, "_8216C810-34D8-4BFA-B814-1AA01907810F");
        factory.connection(1L, 3L, "_58684613-0155-48B2-8746-7675AFF24439");
        factory.validate();
        return factory.getProcess();
    }

    @PostConstruct
    public void init() {
        this.configure();
    }
}

