/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.examples;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.kie.kogito.examples.OrdersModel;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.WorkItem;

@Path(value="/orders")
@Api(description="Deals with orders created by customer")
public class OrdersResource {
    @Inject
    @Named(value="demo.orders")
    Process<OrdersModel> process;

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Creates new instance of orders")
    public OrdersModel createResource_orders(@ApiParam(value="orders data that should be created") OrdersModel resource) {
        if (resource == null) {
            resource = new OrdersModel();
        }
        ProcessInstance pi = this.process.createInstance((Object)resource);
        pi.start();
        return (OrdersModel)pi.variables();
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Returns a list of orders")
    public List<OrdersModel> getResources_orders() {
        return this.process.instances().values().stream().map(ProcessInstance::variables).collect(Collectors.toList());
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Returns information about specified orders")
    public OrdersModel getResource_orders(@PathParam(value="id") Long id) {
        return this.process.instances().findById(id.longValue()).map(ProcessInstance::variables).orElse(null);
    }

    @DELETE
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Cancels specified orders")
    public OrdersModel deleteResource_orders(@PathParam(value="id") Long id) {
        ProcessInstance pi = this.process.instances().findById(id.longValue()).orElse(null);
        if (pi == null) {
            return null;
        }
        pi.abort();
        return (OrdersModel)pi.variables();
    }

    @GET
    @Path(value="/{id}/tasks")
    @Produces(value={"application/json"})
    @ApiOperation(value="Returns list of task ids that are currently active in given orders")
    public Map<Long, String> getTasks_orders(@PathParam(value="id") Long id) {
        return this.process.instances().findById(id.longValue()).map(ProcessInstance::workItems).map(l -> l.stream().collect(Collectors.toMap(WorkItem::getId, WorkItem::getName))).orElse(null);
    }
}

