package org.kie.kogito.app;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kie.kogito.decision.DecisionConfig;
import org.kie.kogito.process.ProcessConfig;
import org.kie.kogito.rules.RuleConfig;

@org.springframework.stereotype.Component()
public class ApplicationConfig implements org.kie.kogito.Config {

    protected ProcessConfig processConfig;

    protected RuleConfig ruleConfig;

    protected DecisionConfig decisionConfig;

    @org.springframework.beans.factory.annotation.Autowired(required = false)
    java.util.Collection<org.kie.kogito.decision.DecisionEventListenerConfig> decisionEventListenerConfigs;

    @org.springframework.beans.factory.annotation.Autowired(required = false)
    java.util.Collection<org.kie.dmn.api.core.event.DMNRuntimeEventListener> dmnRuntimeEventListeners;

    @Override
    public ProcessConfig process() {
        return processConfig;
    }

    @Override
    public RuleConfig rule() {
        return ruleConfig;
    }

    @Override
    public DecisionConfig decision() {
        return decisionConfig;
    }

    private static <C, L> List<L> merge(Collection<C> configs, Function<C, Collection<L>> configToListeners, Collection<L> listeners) {
        return Stream.concat(configs.stream().flatMap(c -> configToListeners.apply(c).stream()), listeners.stream()).collect(Collectors.toList());
    }

    private org.kie.kogito.decision.DecisionEventListenerConfig extract_decisionEventListenerConfig() {
        return this.merge_decisionEventListenerConfig(decisionEventListenerConfigs != null ? decisionEventListenerConfigs : java.util.Collections.emptyList(), dmnRuntimeEventListeners != null ? dmnRuntimeEventListeners : java.util.Collections.emptyList());
    }

    private org.kie.kogito.decision.DecisionEventListenerConfig merge_decisionEventListenerConfig(java.util.Collection<org.kie.kogito.decision.DecisionEventListenerConfig> decisionEventListenerConfigs, java.util.Collection<org.kie.dmn.api.core.event.DMNRuntimeEventListener> dmnRuntimeEventListeners) {
        return new org.kie.kogito.dmn.config.CachedDecisionEventListenerConfig(merge(decisionEventListenerConfigs, org.kie.kogito.decision.DecisionEventListenerConfig::listeners, dmnRuntimeEventListeners));
    }

    public org.kie.kogito.Addons addons() {
        return new org.kie.kogito.Addons(java.util.Arrays.asList());
    }

    @javax.annotation.PostConstruct()
    public void init() {
        processConfig = null;
        ruleConfig = null;
        decisionConfig = new org.kie.kogito.dmn.config.StaticDecisionConfig(extract_decisionEventListenerConfig());
    }
}
