/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.postgresql.model;

import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.persistence.CascadeType;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;
import org.hibernate.annotations.Type;
import org.kie.kogito.index.postgresql.model.AbstractEntity;
import org.kie.kogito.index.postgresql.model.AttachmentEntity;
import org.kie.kogito.index.postgresql.model.CommentEntity;
import org.kie.kogito.persistence.postgresql.hibernate.JsonBinaryType;

@Entity(name="tasks")
@Table(name="tasks")
public class UserTaskInstanceEntity
extends AbstractEntity {
    @Id
    private String id;
    private String description;
    private String name;
    private String priority;
    private String processInstanceId;
    private String state;
    private String actualOwner;
    @ElementCollection
    @JoinColumn(name="task_id")
    @OnDelete(action=OnDeleteAction.CASCADE)
    @CollectionTable(name="tasks_admin_groups", joinColumns={@JoinColumn(name="task_id", foreignKey=@ForeignKey(name="fk_tasks_admin_groups_tasks"))})
    @Column(name="group_id", nullable=false)
    private Set<String> adminGroups;
    @ElementCollection
    @JoinColumn(name="task_id")
    @OnDelete(action=OnDeleteAction.CASCADE)
    @CollectionTable(name="tasks_admin_users", joinColumns={@JoinColumn(name="task_id", foreignKey=@ForeignKey(name="fk_tasks_admin_users_tasks"))})
    @Column(name="user_id", nullable=false)
    private Set<String> adminUsers;
    private ZonedDateTime completed;
    private ZonedDateTime started;
    @ElementCollection
    @JoinColumn(name="task_id")
    @OnDelete(action=OnDeleteAction.CASCADE)
    @CollectionTable(name="tasks_excluded_users", joinColumns={@JoinColumn(name="task_id", foreignKey=@ForeignKey(name="fk_tasks_excluded_users_tasks"))})
    @Column(name="user_id", nullable=false)
    private Set<String> excludedUsers;
    @ElementCollection
    @JoinColumn(name="task_id")
    @OnDelete(action=OnDeleteAction.CASCADE)
    @CollectionTable(name="tasks_potential_groups", joinColumns={@JoinColumn(name="task_id", foreignKey=@ForeignKey(name="fk_tasks_potential_groups_tasks"))})
    @Column(name="group_id", nullable=false)
    private Set<String> potentialGroups;
    @ElementCollection
    @JoinColumn(name="task_id")
    @OnDelete(action=OnDeleteAction.CASCADE)
    @CollectionTable(name="tasks_potential_users", joinColumns={@JoinColumn(name="task_id", foreignKey=@ForeignKey(name="fk_tasks_potential_users_tasks"))})
    @Column(name="user_id", nullable=false)
    private Set<String> potentialUsers;
    private String referenceName;
    private ZonedDateTime lastUpdate;
    private String processId;
    private String rootProcessId;
    private String rootProcessInstanceId;
    @Type(value=JsonBinaryType.class)
    @Column(columnDefinition="jsonb")
    private ObjectNode inputs;
    @Type(value=JsonBinaryType.class)
    @Column(columnDefinition="jsonb")
    private ObjectNode outputs;
    private String endpoint;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="userTask")
    private List<CommentEntity> comments;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="userTask")
    private List<AttachmentEntity> attachments;

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getActualOwner() {
        return this.actualOwner;
    }

    public void setActualOwner(String actualOwner) {
        this.actualOwner = actualOwner;
    }

    public Set<String> getAdminGroups() {
        return this.adminGroups;
    }

    public void setAdminGroups(Set<String> adminGroups) {
        this.adminGroups = adminGroups;
    }

    public Set<String> getAdminUsers() {
        return this.adminUsers;
    }

    public void setAdminUsers(Set<String> adminUsers) {
        this.adminUsers = adminUsers;
    }

    public ZonedDateTime getCompleted() {
        return this.completed;
    }

    public void setCompleted(ZonedDateTime completed) {
        this.completed = completed;
    }

    public ZonedDateTime getStarted() {
        return this.started;
    }

    public void setStarted(ZonedDateTime started) {
        this.started = started;
    }

    public Set<String> getExcludedUsers() {
        return this.excludedUsers;
    }

    public void setExcludedUsers(Set<String> excludedUsers) {
        this.excludedUsers = excludedUsers;
    }

    public Set<String> getPotentialGroups() {
        return this.potentialGroups;
    }

    public void setPotentialGroups(Set<String> potentialGroups) {
        this.potentialGroups = potentialGroups;
    }

    public Set<String> getPotentialUsers() {
        return this.potentialUsers;
    }

    public void setPotentialUsers(Set<String> potentialUsers) {
        this.potentialUsers = potentialUsers;
    }

    public String getReferenceName() {
        return this.referenceName;
    }

    public void setReferenceName(String referenceName) {
        this.referenceName = referenceName;
    }

    public ZonedDateTime getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(ZonedDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public String getRootProcessId() {
        return this.rootProcessId;
    }

    public void setRootProcessId(String rootProcessId) {
        this.rootProcessId = rootProcessId;
    }

    public String getRootProcessInstanceId() {
        return this.rootProcessInstanceId;
    }

    public void setRootProcessInstanceId(String rootProcessInstanceId) {
        this.rootProcessInstanceId = rootProcessInstanceId;
    }

    public ObjectNode getInputs() {
        return this.inputs;
    }

    public void setInputs(ObjectNode inputs) {
        this.inputs = inputs;
    }

    public ObjectNode getOutputs() {
        return this.outputs;
    }

    public void setOutputs(ObjectNode outputs) {
        this.outputs = outputs;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public List<CommentEntity> getComments() {
        return this.comments;
    }

    public void setComments(List<CommentEntity> comments) {
        this.comments = comments;
    }

    public List<AttachmentEntity> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<AttachmentEntity> attachments) {
        this.attachments = attachments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserTaskInstanceEntity that = (UserTaskInstanceEntity)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "UserTaskInstanceEntity{id='" + this.id + "', description='" + this.description + "', name='" + this.name + "', priority='" + this.priority + "', processInstanceId='" + this.processInstanceId + "', state='" + this.state + "', actualOwner='" + this.actualOwner + "', adminGroups=" + this.adminGroups + ", adminUsers=" + this.adminUsers + ", completed=" + this.completed + ", started=" + this.started + ", excludedUsers=" + this.excludedUsers + ", potentialGroups=" + this.potentialGroups + ", potentialUsers=" + this.potentialUsers + ", referenceName='" + this.referenceName + "', lastUpdate=" + this.lastUpdate + ", processId='" + this.processId + "', rootProcessId='" + this.rootProcessId + "', rootProcessInstanceId='" + this.rootProcessInstanceId + "', inputs=" + this.inputs + ", outputs=" + this.outputs + ", endpoint='" + this.endpoint + "', comments='" + this.comments + "', attachments='" + this.attachments + "'}";
    }
}

