/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.mongodb.model;

import com.fasterxml.jackson.databind.JsonNode;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bson.Document;
import org.kie.kogito.index.model.Milestone;
import org.kie.kogito.index.model.NodeInstance;
import org.kie.kogito.index.model.ProcessInstance;
import org.kie.kogito.index.model.ProcessInstanceError;
import org.kie.kogito.index.mongodb.model.ProcessInstanceEntity;
import org.kie.kogito.persistence.mongodb.model.ModelUtils;
import org.kie.kogito.persistence.mongodb.model.MongoEntityMapper;

public class ProcessInstanceEntityMapper
implements MongoEntityMapper<ProcessInstance, ProcessInstanceEntity> {
    static final String NODES_ID_ATTRIBUTE = "nodes.id";
    static final String MONGO_NODES_ID_ATTRIBUTE = "nodes._id";
    static final String MILESTONES_ID_ATTRIBUTE = "milestones.id";
    static final String MONGO_MILESTONES_ID_ATTRIBUTE = "milestones._id";

    public Class<ProcessInstanceEntity> getEntityClass() {
        return ProcessInstanceEntity.class;
    }

    public ProcessInstanceEntity mapToEntity(String key, ProcessInstance instance) {
        if (instance == null) {
            return null;
        }
        ProcessInstanceEntity entity = new ProcessInstanceEntity();
        entity.setId(instance.getId());
        entity.setProcessId(instance.getProcessId());
        entity.setRoles(instance.getRoles());
        entity.setVariables(ModelUtils.jsonNodeToDocument((JsonNode)instance.getVariables()));
        entity.setEndpoint(instance.getEndpoint());
        entity.setNodes(Optional.ofNullable(instance.getNodes()).map(nodes -> nodes.stream().map(this::fromNodeInstance).collect(Collectors.toList())).orElse(null));
        entity.setState(instance.getState());
        entity.setStart(ModelUtils.zonedDateTimeToInstant((ZonedDateTime)instance.getStart()));
        entity.setEnd(ModelUtils.zonedDateTimeToInstant((ZonedDateTime)instance.getEnd()));
        entity.setRootProcessId(instance.getRootProcessId());
        entity.setRootProcessInstanceId(instance.getRootProcessInstanceId());
        entity.setParentProcessInstanceId(instance.getParentProcessInstanceId());
        entity.setProcessName(instance.getProcessName());
        entity.setError(Optional.ofNullable(instance.getError()).map(this::fromProcessInstanceError).orElse(null));
        entity.setAddons(instance.getAddons());
        entity.setLastUpdate(ModelUtils.zonedDateTimeToInstant((ZonedDateTime)instance.getLastUpdate()));
        entity.setBusinessKey(instance.getBusinessKey());
        entity.setMilestones(Optional.ofNullable(instance.getMilestones()).map(milestones -> milestones.stream().map(this::fromMilestone).collect(Collectors.toList())).orElse(null));
        return entity;
    }

    public ProcessInstance mapToModel(ProcessInstanceEntity entity) {
        if (entity == null) {
            return null;
        }
        ProcessInstance instance = new ProcessInstance();
        instance.setId(entity.getId());
        instance.setProcessId(entity.getProcessId());
        instance.setRoles(entity.getRoles());
        instance.setVariables(ModelUtils.documentToJsonNode((Document)entity.getVariables(), JsonNode.class));
        instance.setEndpoint(entity.getEndpoint());
        instance.setNodes((List)Optional.ofNullable(entity.getNodes()).map(nodes -> nodes.stream().map(this::toNodeInstance).collect(Collectors.toList())).orElse(null));
        instance.setState(entity.getState());
        instance.setStart(ModelUtils.instantToZonedDateTime((Long)entity.getStart()));
        instance.setEnd(ModelUtils.instantToZonedDateTime((Long)entity.getEnd()));
        instance.setRootProcessId(entity.getRootProcessId());
        instance.setRootProcessInstanceId(entity.getRootProcessInstanceId());
        instance.setParentProcessInstanceId(entity.getParentProcessInstanceId());
        instance.setProcessName(entity.getProcessName());
        instance.setError((ProcessInstanceError)Optional.ofNullable(entity.getError()).map(this::toProcessInstanceError).orElse(null));
        instance.setAddons(entity.getAddons());
        instance.setLastUpdate(ModelUtils.instantToZonedDateTime((Long)entity.getLastUpdate()));
        instance.setBusinessKey(entity.getBusinessKey());
        instance.setMilestones((List)Optional.ofNullable(entity.getMilestones()).map(milesteons -> milesteons.stream().map(this::toMilestone).collect(Collectors.toList())).orElse(null));
        return instance;
    }

    public String convertToMongoAttribute(String attribute) {
        if (NODES_ID_ATTRIBUTE.equals(attribute)) {
            return MONGO_NODES_ID_ATTRIBUTE;
        }
        if (MILESTONES_ID_ATTRIBUTE.equals(attribute)) {
            return MONGO_MILESTONES_ID_ATTRIBUTE;
        }
        return super.convertToMongoAttribute(attribute);
    }

    public String convertToModelAttribute(String attribute) {
        if (MONGO_NODES_ID_ATTRIBUTE.equals(attribute)) {
            return "id";
        }
        if (MONGO_MILESTONES_ID_ATTRIBUTE.equals(attribute)) {
            return "id";
        }
        return super.convertToModelAttribute(attribute);
    }

    NodeInstance toNodeInstance(ProcessInstanceEntity.NodeInstanceEntity entity) {
        if (entity == null) {
            return null;
        }
        NodeInstance instance = new NodeInstance();
        instance.setId(entity.getId());
        instance.setName(entity.getName());
        instance.setNodeId(entity.getNodeId());
        instance.setType(entity.getType());
        instance.setEnter(ModelUtils.instantToZonedDateTime((Long)entity.getEnter()));
        instance.setExit(ModelUtils.instantToZonedDateTime((Long)entity.getExit()));
        instance.setDefinitionId(entity.getDefinitionId());
        return instance;
    }

    ProcessInstanceEntity.NodeInstanceEntity fromNodeInstance(NodeInstance instance) {
        if (instance == null) {
            return null;
        }
        ProcessInstanceEntity.NodeInstanceEntity entity = new ProcessInstanceEntity.NodeInstanceEntity();
        entity.setId(instance.getId());
        entity.setName(instance.getName());
        entity.setNodeId(instance.getNodeId());
        entity.setType(instance.getType());
        entity.setEnter(ModelUtils.zonedDateTimeToInstant((ZonedDateTime)instance.getEnter()));
        entity.setExit(ModelUtils.zonedDateTimeToInstant((ZonedDateTime)instance.getExit()));
        entity.setDefinitionId(instance.getDefinitionId());
        return entity;
    }

    ProcessInstanceError toProcessInstanceError(ProcessInstanceEntity.ProcessInstanceErrorEntity entity) {
        if (entity == null) {
            return null;
        }
        ProcessInstanceError error = new ProcessInstanceError();
        error.setNodeDefinitionId(entity.getNodeDefinitionId());
        error.setMessage(entity.getMessage());
        return error;
    }

    ProcessInstanceEntity.ProcessInstanceErrorEntity fromProcessInstanceError(ProcessInstanceError error) {
        if (error == null) {
            return null;
        }
        ProcessInstanceEntity.ProcessInstanceErrorEntity entity = new ProcessInstanceEntity.ProcessInstanceErrorEntity();
        entity.setNodeDefinitionId(error.getNodeDefinitionId());
        entity.setMessage(error.getMessage());
        return entity;
    }

    Milestone toMilestone(ProcessInstanceEntity.MilestoneEntity entity) {
        if (entity == null) {
            return null;
        }
        Milestone milestone = new Milestone();
        milestone.setId(entity.getId());
        milestone.setName(entity.getName());
        milestone.setStatus(entity.getStatus());
        return milestone;
    }

    ProcessInstanceEntity.MilestoneEntity fromMilestone(Milestone milestone) {
        if (milestone == null) {
            return null;
        }
        ProcessInstanceEntity.MilestoneEntity entity = new ProcessInstanceEntity.MilestoneEntity();
        entity.setId(milestone.getId());
        entity.setName(milestone.getName());
        entity.setStatus(milestone.getStatus());
        return entity;
    }
}

