/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.tree.compiler.factories;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodReferenceExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import java.util.Map;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.exceptions.KiePMMLInternalException;
import org.kie.pmml.compiler.api.dto.CompilationDTO;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLModelFactoryUtils;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.pmml.models.tree.compiler.dto.TreeCompilationDTO;
import org.kie.pmml.models.tree.compiler.factories.KiePMMLNodeFactory;
import org.kie.pmml.models.tree.compiler.utils.KiePMMLTreeModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiePMMLTreeModelFactory {
    static final String KIE_PMML_TREE_MODEL_TEMPLATE_JAVA = "KiePMMLTreeModelTemplate.tmpl";
    static final String KIE_PMML_TREE_MODEL_TEMPLATE = "KiePMMLTreeModelTemplate";
    private static final Logger logger = LoggerFactory.getLogger((String)KiePMMLTreeModelFactory.class.getName());

    private KiePMMLTreeModelFactory() {
    }

    public static Map<String, String> getKiePMMLTreeModelSourcesMap(TreeCompilationDTO compilationDTO) {
        logger.trace("getKiePMMLTreeModelSourcesMap {} {} {}", new Object[]{compilationDTO.getFields(), compilationDTO.getModel(), compilationDTO.getPackageName()});
        String className = compilationDTO.getSimpleClassName();
        String packageName = compilationDTO.getPackageName();
        CompilationUnit cloneCU = JavaParserUtils.getKiePMMLModelCompilationUnit((String)className, (String)packageName, (String)KIE_PMML_TREE_MODEL_TEMPLATE_JAVA, (String)KIE_PMML_TREE_MODEL_TEMPLATE);
        ClassOrInterfaceDeclaration modelTemplate = (ClassOrInterfaceDeclaration)cloneCU.getClassByName(className).orElseThrow(() -> new KiePMMLException("Main class not found: " + className));
        Double missingValuePenalty = compilationDTO.getMissingValuePenalty();
        KiePMMLNodeFactory.NodeNamesDTO nodeNamesDTO = new KiePMMLNodeFactory.NodeNamesDTO(compilationDTO.getNode(), KiePMMLTreeModelUtils.createNodeClassName(), null, missingValuePenalty);
        String fullNodeClassName = packageName + "." + nodeNamesDTO.nodeClassName;
        Map<String, String> toReturn = KiePMMLNodeFactory.getKiePMMLNodeSourcesMap(nodeNamesDTO, compilationDTO.getFields(), packageName);
        KiePMMLTreeModelFactory.setConstructor(compilationDTO, modelTemplate, fullNodeClassName);
        String fullClassName = packageName + "." + className;
        toReturn.put(fullClassName, cloneCU.toString());
        return toReturn;
    }

    static void setConstructor(TreeCompilationDTO compilationDTO, ClassOrInterfaceDeclaration modelTemplate, String fullNodeClassName) {
        KiePMMLModelFactoryUtils.init((CompilationDTO)compilationDTO, (ClassOrInterfaceDeclaration)modelTemplate);
        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)modelTemplate.getDefaultConstructor().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing default constructor in ClassOrInterfaceDeclaration %s ", modelTemplate.getName())));
        BlockStmt body = constructorDeclaration.getBody();
        MethodReferenceExpr nodeReference = new MethodReferenceExpr();
        nodeReference.setScope((Expression)new NameExpr(fullNodeClassName));
        nodeReference.setIdentifier("evaluateNode");
        CommonCodegenUtils.setAssignExpressionValue((BlockStmt)body, (String)"nodeFunction", (Expression)nodeReference);
    }
}

