/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.mining.evaluator;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.drools.util.StringUtils;
import org.kie.api.pmml.PMML4Result;
import org.kie.pmml.api.enums.MINING_FUNCTION;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.api.enums.ResultCode;
import org.kie.pmml.api.exceptions.KieEnumException;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.exceptions.KiePMMLInternalException;
import org.kie.pmml.api.models.PMMLStep;
import org.kie.pmml.api.runtime.PMMLRuntimeContext;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.commons.model.predicates.KiePMMLPredicate;
import org.kie.pmml.commons.model.tuples.KiePMMLNameValue;
import org.kie.pmml.commons.model.tuples.KiePMMLValueWeight;
import org.kie.pmml.evaluator.api.exceptions.KiePMMLModelException;
import org.kie.pmml.evaluator.core.executor.PMMLModelEvaluator;
import org.kie.pmml.evaluator.core.utils.Converter;
import org.kie.pmml.evaluator.core.utils.PMMLListenerUtils;
import org.kie.pmml.evaluator.core.utils.PMMLRuntimeHelper;
import org.kie.pmml.models.mining.evaluator.PMMLMiningModelStep;
import org.kie.pmml.models.mining.model.KiePMMLMiningModel;
import org.kie.pmml.models.mining.model.enums.MULTIPLE_MODEL_METHOD;
import org.kie.pmml.models.mining.model.segmentation.KiePMMLSegment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PMMLMiningModelEvaluator
implements PMMLModelEvaluator<KiePMMLMiningModel> {
    private static final Logger logger = LoggerFactory.getLogger((String)PMMLMiningModelEvaluator.class.getName());
    private static final String EXPECTED_A_KIE_PMMLMINING_MODEL_RECEIVED = "Expected a KiePMMLMiningModel, received %s";
    private static final String TARGET_FIELD_REQUIRED_RETRIEVED = "TargetField required, retrieved %s";

    public PMML_MODEL getPMMLModelType() {
        return PMML_MODEL.MINING_MODEL;
    }

    public PMML4Result evaluate(KiePMMLMiningModel model, PMMLRuntimeContext pmmlContext) {
        this.validate((KiePMMLModel)model);
        return this.evaluateMiningModel(model, pmmlContext);
    }

    PMML4Result getPMML4Result(KiePMMLMiningModel toEvaluate, LinkedHashMap<String, KiePMMLNameValueProbabilityMapTuple> inputData, PMMLRuntimeContext pmmlContext) {
        MULTIPLE_MODEL_METHOD multipleModelMethod = toEvaluate.getSegmentation().getMultipleModelMethod();
        Object result = null;
        LinkedHashMap probabilityResultMap = null;
        ResultCode resultCode = ResultCode.OK;
        LinkedHashMap toUseForPrediction = new LinkedHashMap();
        LinkedHashMap toUseForProbability = new LinkedHashMap();
        inputData.forEach((key, value) -> {
            toUseForPrediction.put(key, value.predictionValue);
            toUseForProbability.put(key, value.probabilityValues);
        });
        try {
            if (MINING_FUNCTION.CLASSIFICATION.equals((Object)toEvaluate.getMiningFunction())) {
                result = multipleModelMethod.applyClassification(toUseForPrediction);
                probabilityResultMap = multipleModelMethod.applyProbability(toUseForProbability);
            } else {
                result = multipleModelMethod.applyPrediction(toUseForPrediction);
            }
        }
        catch (KieEnumException e) {
            logger.warn(e.getMessage());
            resultCode = ResultCode.FAIL;
        }
        pmmlContext.setProbabilityResultMap(probabilityResultMap);
        PMML4Result toReturn = new PMML4Result();
        toReturn.addResultVariable(toEvaluate.getTargetField(), result);
        toReturn.setResultObjectName(toEvaluate.getTargetField());
        toReturn.setResultCode(resultCode.getName());
        return toReturn;
    }

    KiePMMLNameValue getKiePMMLNameValue(PMML4Result result, MULTIPLE_MODEL_METHOD multipleModelMethod, double weight) {
        String fieldName = result.getResultObjectName();
        Object retrieved = this.getEventuallyWeightedResult(result.getResultVariables().get(fieldName), multipleModelMethod, weight);
        return new KiePMMLNameValue(fieldName, retrieved);
    }

    List<KiePMMLNameValue> getKiePMMLNameValues(Map<String, Double> probabilityMap, MULTIPLE_MODEL_METHOD multipleModelMethod, double weight) {
        return probabilityMap.entrySet().stream().map(stringDoubleEntry -> {
            Object retrieved = this.getEventuallyWeightedResult(stringDoubleEntry.getValue(), multipleModelMethod, weight);
            return new KiePMMLNameValue((String)stringDoubleEntry.getKey(), retrieved);
        }).collect(Collectors.toList());
    }

    Object getEventuallyWeightedResult(Object rawObject, MULTIPLE_MODEL_METHOD multipleModelMethod, double weight) {
        switch (multipleModelMethod) {
            case MAJORITY_VOTE: 
            case MODEL_CHAIN: 
            case SELECT_ALL: 
            case SELECT_FIRST: {
                return rawObject;
            }
            case MAX: 
            case SUM: 
            case MEDIAN: 
            case AVERAGE: 
            case WEIGHTED_SUM: 
            case WEIGHTED_MEDIAN: 
            case WEIGHTED_AVERAGE: {
                if (!(rawObject instanceof Number)) {
                    throw new KiePMMLException("Expected a number, retrieved " + rawObject.getClass().getName());
                }
                return new KiePMMLValueWeight(((Number)rawObject).doubleValue(), weight);
            }
            case WEIGHTED_MAJORITY_VOTE: {
                throw new KiePMMLException(multipleModelMethod + " not implemented, yet");
            }
        }
        throw new KiePMMLException("Unrecognized MULTIPLE_MODEL_METHOD " + multipleModelMethod);
    }

    void validate(KiePMMLModel toValidate) {
        if (!(toValidate instanceof KiePMMLMiningModel)) {
            throw new KiePMMLModelException(String.format(EXPECTED_A_KIE_PMMLMINING_MODEL_RECEIVED, toValidate.getClass().getName()));
        }
        this.validateMining((KiePMMLMiningModel)toValidate);
    }

    void validateMining(KiePMMLMiningModel toValidate) {
        if (toValidate.getTargetField() == null || StringUtils.isEmpty((CharSequence)toValidate.getTargetField().trim())) {
            throw new KiePMMLInternalException(String.format(TARGET_FIELD_REQUIRED_RETRIEVED, toValidate.getTargetField()));
        }
    }

    void populateInputDataWithSegmentResult(PMML4Result pmml4Result, PMMLRuntimeContext pmmlContext, MULTIPLE_MODEL_METHOD multipleModelMethod, KiePMMLSegment segment, LinkedHashMap<String, KiePMMLNameValueProbabilityMapTuple> toPopulate) {
        pmml4Result.getResultVariables().forEach((s, o) -> pmmlContext.getRequestData().addRequestParam(s, o));
        PMML4ResultProbabilityMapTuple pmml4ResultTuple = new PMML4ResultProbabilityMapTuple(pmml4Result, pmmlContext.getProbabilityMap());
        KiePMMLNameValue predictionValue = this.getKiePMMLNameValue(pmml4ResultTuple.pmml4Result, multipleModelMethod, segment.getWeight());
        List<KiePMMLNameValue> probabilityValues = this.getKiePMMLNameValues(pmml4ResultTuple.probabilityResultMap, multipleModelMethod, segment.getWeight());
        toPopulate.put(segment.getId(), new KiePMMLNameValueProbabilityMapTuple(predictionValue, probabilityValues));
        this.addStep(() -> this.getStep(segment, pmml4Result), pmmlContext);
    }

    void addStep(Supplier<PMMLStep> stepSupplier, PMMLRuntimeContext pmmlContext) {
        PMMLListenerUtils.stepExecuted(stepSupplier, (PMMLRuntimeContext)pmmlContext);
    }

    PMMLStep getStep(KiePMMLSegment segment, PMML4Result pmml4Result) {
        PMMLMiningModelStep toReturn = new PMMLMiningModelStep();
        toReturn.addInfo("SEGMENT", segment.getName());
        toReturn.addInfo("MODEL", segment.getModel().getName());
        toReturn.addInfo("RESULT CODE", pmml4Result.getResultCode());
        if (ResultCode.OK.getName().equals(pmml4Result.getResultCode())) {
            toReturn.addInfo("RESULT", pmml4Result.getResultVariables().get(pmml4Result.getResultObjectName()));
        }
        return toReturn;
    }

    private PMML4Result evaluateMiningModel(KiePMMLMiningModel toEvaluate, PMMLRuntimeContext pmmlContext) {
        MULTIPLE_MODEL_METHOD multipleModelMethod = toEvaluate.getSegmentation().getMultipleModelMethod();
        List segments = toEvaluate.getSegmentation().getSegments();
        LinkedHashMap<String, KiePMMLNameValueProbabilityMapTuple> inputData = new LinkedHashMap<String, KiePMMLNameValueProbabilityMapTuple>();
        for (KiePMMLSegment segment : segments) {
            Optional<PMML4Result> segmentResult = this.evaluateSegment(segment, pmmlContext);
            segmentResult.ifPresent(pmml4Result -> this.populateInputDataWithSegmentResult((PMML4Result)pmml4Result, pmmlContext, multipleModelMethod, segment, inputData));
        }
        return this.getPMML4Result(toEvaluate, inputData, pmmlContext);
    }

    private Optional<PMML4Result> evaluateSegment(KiePMMLSegment toEvaluate, PMMLRuntimeContext pmmlContext) {
        logger.trace("evaluateSegment {}", (Object)toEvaluate.getId());
        KiePMMLPredicate kiePMMLPredicate = toEvaluate.getKiePMMLPredicate();
        Optional<PMML4Result> toReturn = Optional.empty();
        Map values = Converter.getUnwrappedParametersMap((Map)pmmlContext.getRequestData().getMappedRequestParams());
        if (kiePMMLPredicate.evaluate(values)) {
            toReturn = Optional.ofNullable(PMMLRuntimeHelper.evaluate((KiePMMLModel)toEvaluate.getModel(), (PMMLRuntimeContext)pmmlContext));
        }
        return toReturn;
    }

    static class KiePMMLNameValueProbabilityMapTuple {
        private final KiePMMLNameValue predictionValue;
        private final List<KiePMMLNameValue> probabilityValues;

        public KiePMMLNameValueProbabilityMapTuple(KiePMMLNameValue kiePMMLNameValue, List<KiePMMLNameValue> probabilityValues) {
            this.predictionValue = kiePMMLNameValue;
            this.probabilityValues = probabilityValues;
        }
    }

    static class PMML4ResultProbabilityMapTuple {
        private final PMML4Result pmml4Result;
        private final Map<String, Double> probabilityResultMap;

        public PMML4ResultProbabilityMapTuple(PMML4Result pmml4Result, Map<String, Double> probabilityResultMap) {
            this.pmml4Result = pmml4Result;
            this.probabilityResultMap = probabilityResultMap;
        }
    }
}

