/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.mining.evaluator;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.impl.RuleBase;
import org.drools.core.util.StringUtils;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.kie.api.KieBase;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.definition.KiePackage;
import org.kie.api.pmml.PMML4Result;
import org.kie.api.runtime.KieRuntimeFactory;
import org.kie.pmml.api.enums.MINING_FUNCTION;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.api.enums.ResultCode;
import org.kie.pmml.api.exceptions.KieEnumException;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.exceptions.KiePMMLInternalException;
import org.kie.pmml.api.runtime.PMMLContext;
import org.kie.pmml.api.runtime.PMMLRuntime;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.commons.model.predicates.KiePMMLPredicate;
import org.kie.pmml.commons.model.tuples.KiePMMLNameValue;
import org.kie.pmml.commons.model.tuples.KiePMMLValueWeight;
import org.kie.pmml.evaluator.api.exceptions.KiePMMLModelException;
import org.kie.pmml.evaluator.core.executor.PMMLModelEvaluator;
import org.kie.pmml.evaluator.core.utils.Converter;
import org.kie.pmml.models.mining.model.KiePMMLMiningModel;
import org.kie.pmml.models.mining.model.enums.MULTIPLE_MODEL_METHOD;
import org.kie.pmml.models.mining.model.segmentation.KiePMMLSegment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PMMLMiningModelEvaluator
implements PMMLModelEvaluator<KiePMMLMiningModel> {
    private static final Logger logger = LoggerFactory.getLogger((String)PMMLMiningModelEvaluator.class.getName());
    private static final String EXPECTED_A_KIE_PMMLMINING_MODEL_RECEIVED = "Expected a KiePMMLMiningModel, received %s";
    private static final String TARGET_FIELD_REQUIRED_RETRIEVED = "TargetField required, retrieved %s";
    private static final Map<String, InternalKnowledgeBase> MAPPED_KIEBASES = new HashMap<String, InternalKnowledgeBase>();

    public PMML_MODEL getPMMLModelType() {
        return PMML_MODEL.MINING_MODEL;
    }

    public PMML4Result evaluate(KieBase knowledgeBase, KiePMMLMiningModel model, PMMLContext pmmlContext) {
        this.validate((KiePMMLModel)model);
        return this.evaluateMiningModel(model, pmmlContext, knowledgeBase);
    }

    PMML4Result getPMML4Result(KiePMMLMiningModel toEvaluate, LinkedHashMap<String, KiePMMLNameValueProbabilityMapTuple> inputData, PMMLContext pmmlContext) {
        MULTIPLE_MODEL_METHOD multipleModelMethod = toEvaluate.getSegmentation().getMultipleModelMethod();
        Object result = null;
        LinkedHashMap probabilityResultMap = null;
        ResultCode resultCode = ResultCode.OK;
        LinkedHashMap toUseForPrediction = new LinkedHashMap();
        LinkedHashMap toUseForProbability = new LinkedHashMap();
        inputData.forEach((key, value) -> {
            toUseForPrediction.put(key, ((KiePMMLNameValueProbabilityMapTuple)value).predictionValue);
            toUseForProbability.put(key, ((KiePMMLNameValueProbabilityMapTuple)value).probabilityValues);
        });
        try {
            if (MINING_FUNCTION.CLASSIFICATION.equals((Object)toEvaluate.getMiningFunction())) {
                result = multipleModelMethod.applyClassification(toUseForPrediction);
                probabilityResultMap = multipleModelMethod.applyProbability(toUseForProbability);
            } else {
                result = multipleModelMethod.applyPrediction(toUseForPrediction);
            }
        }
        catch (KieEnumException e) {
            logger.warn(e.getMessage());
            resultCode = ResultCode.FAIL;
        }
        pmmlContext.setProbabilityResultMap(probabilityResultMap);
        PMML4Result toReturn = new PMML4Result();
        toReturn.addResultVariable(toEvaluate.getTargetField(), result);
        toReturn.setResultObjectName(toEvaluate.getTargetField());
        toReturn.setResultCode(resultCode.getName());
        return toReturn;
    }

    PMMLRuntime getPMMLRuntime(String kModulePackageName, KieBase knowledgeBase, String containerModelName) {
        String key = containerModelName + "_" + kModulePackageName;
        InternalKnowledgeBase kieBase = MAPPED_KIEBASES.computeIfAbsent(key, s -> {
            KiePackage kiePackage = knowledgeBase.getKiePackage(kModulePackageName);
            List packages = kiePackage != null ? Collections.singletonList(knowledgeBase.getKiePackage(kModulePackageName)) : Collections.emptyList();
            RuleBaseConfiguration conf = new RuleBaseConfiguration();
            conf.setClassLoader(((RuleBase)knowledgeBase).getRootClassLoader());
            InternalKnowledgeBase toReturn = KnowledgeBaseFactory.newKnowledgeBase((String)kModulePackageName, (KieBaseConfiguration)conf);
            toReturn.addPackages(packages);
            return toReturn;
        });
        KieRuntimeFactory kieRuntimeFactory = KieRuntimeFactory.of((KieBase)kieBase);
        return (PMMLRuntime)kieRuntimeFactory.get(PMMLRuntime.class);
    }

    KiePMMLNameValue getKiePMMLNameValue(PMML4Result result, MULTIPLE_MODEL_METHOD multipleModelMethod, double weight) {
        String fieldName = result.getResultObjectName();
        Object retrieved = this.getEventuallyWeightedResult(result.getResultVariables().get(fieldName), multipleModelMethod, weight);
        return new KiePMMLNameValue(fieldName, retrieved);
    }

    List<KiePMMLNameValue> getKiePMMLNameValues(Map<String, Double> probabilityMap, MULTIPLE_MODEL_METHOD multipleModelMethod, double weight) {
        return probabilityMap.entrySet().stream().map(stringDoubleEntry -> {
            Object retrieved = this.getEventuallyWeightedResult(stringDoubleEntry.getValue(), multipleModelMethod, weight);
            return new KiePMMLNameValue((String)stringDoubleEntry.getKey(), retrieved);
        }).collect(Collectors.toList());
    }

    Object getEventuallyWeightedResult(Object rawObject, MULTIPLE_MODEL_METHOD multipleModelMethod, double weight) {
        switch (multipleModelMethod) {
            case MAJORITY_VOTE: 
            case MODEL_CHAIN: 
            case SELECT_ALL: 
            case SELECT_FIRST: {
                return rawObject;
            }
            case MAX: 
            case SUM: 
            case MEDIAN: 
            case AVERAGE: 
            case WEIGHTED_SUM: 
            case WEIGHTED_MEDIAN: 
            case WEIGHTED_AVERAGE: {
                if (!(rawObject instanceof Number)) {
                    throw new KiePMMLException("Expected a number, retrieved " + rawObject.getClass().getName());
                }
                return new KiePMMLValueWeight(((Number)rawObject).doubleValue(), weight);
            }
            case WEIGHTED_MAJORITY_VOTE: {
                throw new KiePMMLException(multipleModelMethod + " not implemented, yet");
            }
        }
        throw new KiePMMLException("Unrecognized MULTIPLE_MODEL_METHOD " + multipleModelMethod);
    }

    void validate(KiePMMLModel toValidate) {
        if (!(toValidate instanceof KiePMMLMiningModel)) {
            throw new KiePMMLModelException(String.format(EXPECTED_A_KIE_PMMLMINING_MODEL_RECEIVED, toValidate.getClass().getName()));
        }
        this.validateMining((KiePMMLMiningModel)toValidate);
    }

    void validateMining(KiePMMLMiningModel toValidate) {
        if (toValidate.getTargetField() == null || StringUtils.isEmpty((CharSequence)toValidate.getTargetField().trim())) {
            throw new KiePMMLInternalException(String.format(TARGET_FIELD_REQUIRED_RETRIEVED, toValidate.getTargetField()));
        }
    }

    private PMML4Result evaluateMiningModel(KiePMMLMiningModel toEvaluate, PMMLContext pmmlContext, KieBase knowledgeBase) {
        MULTIPLE_MODEL_METHOD multipleModelMethod = toEvaluate.getSegmentation().getMultipleModelMethod();
        List segments = toEvaluate.getSegmentation().getSegments();
        LinkedHashMap<String, KiePMMLNameValueProbabilityMapTuple> inputData = new LinkedHashMap<String, KiePMMLNameValueProbabilityMapTuple>();
        for (KiePMMLSegment segment : segments) {
            Optional<PMML4Result> segmentResult = this.evaluateSegment(segment, pmmlContext, knowledgeBase, toEvaluate.getName());
            segmentResult.ifPresent(pmml4Result -> {
                pmml4Result.getResultVariables().forEach((s, o) -> pmmlContext.getRequestData().addRequestParam(s, o));
                PMML4ResultProbabilityMapTuple pmml4ResultTuple = new PMML4ResultProbabilityMapTuple((PMML4Result)pmml4Result, pmmlContext.getProbabilityMap());
                KiePMMLNameValue predictionValue = this.getKiePMMLNameValue(pmml4ResultTuple.pmml4Result, multipleModelMethod, segment.getWeight());
                List<KiePMMLNameValue> probabilityValues = this.getKiePMMLNameValues(pmml4ResultTuple.probabilityResultMap, multipleModelMethod, segment.getWeight());
                inputData.put(segment.getId(), new KiePMMLNameValueProbabilityMapTuple(predictionValue, probabilityValues));
            });
        }
        return this.getPMML4Result(toEvaluate, inputData, pmmlContext);
    }

    private Optional<PMML4Result> evaluateSegment(KiePMMLSegment toEvaluate, PMMLContext pmmlContext, KieBase knowledgeBase, String containerModelName) {
        logger.trace("evaluateSegment {}", (Object)toEvaluate.getId());
        KiePMMLPredicate kiePMMLPredicate = toEvaluate.getKiePMMLPredicate();
        Optional<PMML4Result> toReturn = Optional.empty();
        Map values = Converter.getUnwrappedParametersMap((Map)pmmlContext.getRequestData().getMappedRequestParams());
        String modelName = toEvaluate.getModel().getName();
        if (kiePMMLPredicate.evaluate(values)) {
            PMMLRuntime pmmlRuntime = this.getPMMLRuntime(toEvaluate.getModel().getKModulePackageName(), knowledgeBase, containerModelName);
            logger.trace("{}: matching predicate, evaluating... ", (Object)toEvaluate.getId());
            toReturn = Optional.ofNullable(pmmlRuntime.evaluate(modelName, pmmlContext));
        }
        return toReturn;
    }

    static class KiePMMLNameValueProbabilityMapTuple {
        private final KiePMMLNameValue predictionValue;
        private final List<KiePMMLNameValue> probabilityValues;

        public KiePMMLNameValueProbabilityMapTuple(KiePMMLNameValue kiePMMLNameValue, List<KiePMMLNameValue> probabilityValues) {
            this.predictionValue = kiePMMLNameValue;
            this.probabilityValues = probabilityValues;
        }
    }

    static class PMML4ResultProbabilityMapTuple {
        private final PMML4Result pmml4Result;
        private final Map<String, Double> probabilityResultMap;

        public PMML4ResultProbabilityMapTuple(PMML4Result pmml4Result, Map<String, Double> probabilityResultMap) {
            this.pmml4Result = pmml4Result;
            this.probabilityResultMap = probabilityResultMap;
        }
    }
}

