/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.mining.compiler.factories;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExplicitConstructorInvocationStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.TransformationDictionary;
import org.dmg.pmml.mining.Segmentation;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.exceptions.KiePMMLInternalException;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.compiler.commons.factories.KiePMMLExtensionFactory;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.pmml.compiler.commons.utils.KiePMMLModelFactoryUtils;
import org.kie.pmml.models.mining.compiler.factories.KiePMMLSegmentFactory;
import org.kie.pmml.models.mining.model.enums.MULTIPLE_MODEL_METHOD;
import org.kie.pmml.models.mining.model.segmentation.KiePMMLSegmentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiePMMLSegmentationFactory {
    static final String KIE_PMML_SEGMENTATION_TEMPLATE_JAVA = "KiePMMLSegmentationTemplate.tmpl";
    static final String KIE_PMML_SEGMENTATION_TEMPLATE = "KiePMMLSegmentationTemplate";
    private static final Logger logger = LoggerFactory.getLogger((String)KiePMMLSegmentationFactory.class.getName());

    private KiePMMLSegmentationFactory() {
    }

    public static KiePMMLSegmentation getSegmentation(DataDictionary dataDictionary, TransformationDictionary transformationDictionary, Segmentation segmentation, String segmentationName, KnowledgeBuilder kBuilder) {
        logger.debug("getSegmentation {}", (Object)segmentation);
        return (KiePMMLSegmentation)KiePMMLSegmentation.builder((String)segmentationName, (List)KiePMMLExtensionFactory.getKiePMMLExtensions((List)segmentation.getExtensions()), (MULTIPLE_MODEL_METHOD)MULTIPLE_MODEL_METHOD.byName((String)segmentation.getMultipleModelMethod().value())).withSegments(KiePMMLSegmentFactory.getSegments(dataDictionary, transformationDictionary, segmentation.getSegments(), kBuilder)).build();
    }

    public static Map<String, String> getSegmentationSourcesMap(String parentPackageName, DataDictionary dataDictionary, TransformationDictionary transformationDictionary, Segmentation segmentation, String segmentationName, KnowledgeBuilder kBuilder, List<KiePMMLModel> nestedModels) {
        logger.debug("getSegmentationSourcesMap {}", (Object)segmentation);
        String packageName = KiePMMLModelUtils.getSanitizedPackageName((String)(parentPackageName + "." + segmentationName));
        Map<String, String> toReturn = KiePMMLSegmentFactory.getSegmentsSourcesMap(packageName, dataDictionary, transformationDictionary, segmentation.getSegments(), kBuilder, nestedModels);
        String className = KiePMMLModelUtils.getSanitizedClassName((String)segmentationName);
        CompilationUnit cloneCU = JavaParserUtils.getKiePMMLModelCompilationUnit((String)className, (String)packageName, (String)KIE_PMML_SEGMENTATION_TEMPLATE_JAVA, (String)KIE_PMML_SEGMENTATION_TEMPLATE);
        ClassOrInterfaceDeclaration segmentationTemplate = (ClassOrInterfaceDeclaration)cloneCU.getClassByName(className).orElseThrow(() -> new KiePMMLException("Main class not found: " + className));
        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)segmentationTemplate.getDefaultConstructor().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing default constructor in ClassOrInterfaceDeclaration %s ", segmentationName)));
        Set<String> segmentsClasses = segmentation.getSegments().stream().map(segment -> KiePMMLModelUtils.getSanitizedPackageName((String)(packageName + "." + segment.getId())) + "." + KiePMMLModelUtils.getSanitizedClassName((String)segment.getId())).collect(Collectors.toSet());
        if (!toReturn.keySet().containsAll(segmentsClasses)) {
            String missingClasses = String.join((CharSequence)", ", segmentsClasses);
            throw new KiePMMLException("Expected generated class " + missingClasses + " not found");
        }
        KiePMMLSegmentationFactory.setConstructor(className, segmentationName, constructorDeclaration, MULTIPLE_MODEL_METHOD.byName((String)segmentation.getMultipleModelMethod().value()), segmentsClasses);
        toReturn.put(JavaParserUtils.getFullClassName((CompilationUnit)cloneCU), cloneCU.toString());
        return toReturn;
    }

    static void setConstructor(String generatedClassName, String segmentationName, ConstructorDeclaration constructorDeclaration, MULTIPLE_MODEL_METHOD multipleModelMethod, Set<String> segmentsClasses) {
        KiePMMLModelFactoryUtils.setConstructorSuperNameInvocation((String)generatedClassName, (ConstructorDeclaration)constructorDeclaration, (String)segmentationName);
        BlockStmt body = constructorDeclaration.getBody();
        ExplicitConstructorInvocationStmt superStatement = (ExplicitConstructorInvocationStmt)CommonCodegenUtils.getExplicitConstructorInvocationStmt((BlockStmt)body).orElseThrow(() -> new KiePMMLException(String.format("Missing constructor invocation in body %s", body)));
        CommonCodegenUtils.setExplicitConstructorInvocationArgument((ExplicitConstructorInvocationStmt)superStatement, (String)"multipleModelMethod", (String)(multipleModelMethod.getClass().getCanonicalName() + "." + multipleModelMethod.name()));
        List assignExprs = body.findAll(AssignExpr.class);
        assignExprs.forEach(assignExpr -> {
            if (assignExpr.getTarget().asNameExpr().getNameAsString().equals("segments")) {
                for (String segmentClass : segmentsClasses) {
                    ClassOrInterfaceType kiePMMLSegmentClass = StaticJavaParser.parseClassOrInterfaceType((String)segmentClass);
                    ObjectCreationExpr objectCreationExpr = new ObjectCreationExpr();
                    objectCreationExpr.setType(kiePMMLSegmentClass);
                    NodeList arguments = NodeList.nodeList((Node[])new Expression[]{objectCreationExpr});
                    MethodCallExpr methodCallExpr = new MethodCallExpr();
                    methodCallExpr.setScope((Expression)assignExpr.getTarget().asNameExpr());
                    methodCallExpr.setName("add");
                    methodCallExpr.setArguments(arguments);
                    ExpressionStmt expressionStmt = new ExpressionStmt();
                    expressionStmt.setExpression((Expression)methodCallExpr);
                    body.addStatement((Statement)expressionStmt);
                }
            }
        });
    }
}

