/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.commons.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.pmml.PMML4Result;
import org.kie.efesto.common.api.identifiers.EfestoAppRoot;
import org.kie.efesto.common.api.identifiers.ModelLocalUriId;
import org.kie.efesto.runtimemanager.api.exceptions.KieRuntimeServiceException;
import org.kie.efesto.runtimemanager.api.model.BaseEfestoInput;
import org.kie.efesto.runtimemanager.api.model.EfestoInput;
import org.kie.efesto.runtimemanager.api.model.EfestoMapInputDTO;
import org.kie.efesto.runtimemanager.api.model.EfestoOriginalTypeGeneratedType;
import org.kie.efesto.runtimemanager.api.model.EfestoRuntimeContext;
import org.kie.efesto.runtimemanager.api.service.RuntimeManager;
import org.kie.efesto.runtimemanager.api.utils.SPIUtils;
import org.kie.pmml.api.enums.MINING_FUNCTION;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.api.enums.ResultCode;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.identifiers.KiePmmlComponentRoot;
import org.kie.pmml.api.identifiers.LocalComponentIdRedirectPmml;
import org.kie.pmml.api.identifiers.PmmlIdRedirectFactory;
import org.kie.pmml.api.runtime.PMMLRuntimeContext;
import org.kie.pmml.commons.model.IsDrools;
import org.kie.pmml.commons.model.KiePMMLExtension;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.models.drools.executor.KiePMMLStatusHolder;
import org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType;
import org.kie.pmml.models.drools.utils.KiePMMLAgendaListenerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KiePMMLDroolsModel
extends KiePMMLModel
implements IsDrools {
    private static final Logger logger = LoggerFactory.getLogger(KiePMMLDroolsModel.class);
    private static final AgendaEventListener agendaEventListener = KiePMMLAgendaListenerUtils.getAgendaEventListener(logger);
    private static final long serialVersionUID = 5471400949048174357L;
    protected String kModulePackageName;
    protected Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap = new HashMap<String, KiePMMLOriginalTypeGeneratedType>();

    protected KiePMMLDroolsModel(String fileName, String modelName, List<KiePMMLExtension> extensions) {
        super(fileName, modelName, extensions);
    }

    public Map<String, KiePMMLOriginalTypeGeneratedType> getFieldTypeMap() {
        return this.fieldTypeMap;
    }

    public Object evaluate(Map<String, Object> requestData, PMMLRuntimeContext context) {
        logger.trace("evaluate {}", requestData);
        PMML4Result toReturn = this.getPMML4Result(this.targetField);
        List<Object> inserts = Arrays.asList(new KiePMMLStatusHolder());
        HashMap<String, Object> globals = new HashMap<String, Object>();
        globals.put("$pmml4Result", toReturn);
        globals.put("$outputFieldsMap", context.getOutputFieldsMap());
        Map<String, EfestoOriginalTypeGeneratedType> convertedFieldTypeMap = this.fieldTypeMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new EfestoOriginalTypeGeneratedType(((KiePMMLOriginalTypeGeneratedType)entry.getValue()).getOriginalType(), ((KiePMMLOriginalTypeGeneratedType)entry.getValue()).getGeneratedType())));
        EfestoMapInputDTO darMapInputDTO = new EfestoMapInputDTO(inserts, globals, requestData, convertedFieldTypeMap, this.getName(), this.getKModulePackageName());
        LocalComponentIdRedirectPmml modelLocalUriId = ((PmmlIdRedirectFactory)((KiePmmlComponentRoot)new EfestoAppRoot().get(KiePmmlComponentRoot.class)).get(PmmlIdRedirectFactory.class)).get("drl", context.getFileNameNoSuffix(), KiePMMLModelUtils.getSanitizedClassName((String)this.getName()));
        BaseEfestoInput input = new BaseEfestoInput((ModelLocalUriId)modelLocalUriId, (Object)darMapInputDTO);
        Optional runtimeManager = SPIUtils.getRuntimeManager((boolean)true);
        if (!runtimeManager.isPresent()) {
            throw new KieRuntimeServiceException("Cannot find RuntimeManager");
        }
        Collection output = ((RuntimeManager)runtimeManager.get()).evaluateInput((EfestoRuntimeContext)context, new EfestoInput[]{input});
        if (output.isEmpty()) {
            throw new KiePMMLException("Failed to retrieve value for " + this.getName());
        }
        return toReturn;
    }

    public String getKModulePackageName() {
        return this.kModulePackageName;
    }

    public String toString() {
        return new StringJoiner(", ", KiePMMLDroolsModel.class.getSimpleName() + "[", "]").add("kiePMMLOutputFields=" + this.kiePMMLOutputFields).add("fieldTypeMap=" + this.fieldTypeMap).add("pmmlMODEL=" + this.pmmlMODEL).add("miningFunction=" + this.miningFunction).add("targetField='" + this.targetField + "'").add("name='" + this.name + "'").add("extensions=" + this.extensions).add("id='" + this.id + "'").add("parentId='" + this.parentId + "'").toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        KiePMMLDroolsModel that = (KiePMMLDroolsModel)((Object)o);
        return Objects.equals(this.kiePMMLOutputFields, that.kiePMMLOutputFields) && Objects.equals(this.fieldTypeMap, that.fieldTypeMap);
    }

    public int hashCode() {
        return Objects.hash(this.kiePMMLOutputFields, this.fieldTypeMap);
    }

    private PMML4Result getPMML4Result(String targetField) {
        PMML4Result toReturn = new PMML4Result();
        toReturn.setResultCode(ResultCode.FAIL.getName());
        toReturn.setResultObjectName(targetField);
        return toReturn;
    }

    public static abstract class Builder<T extends KiePMMLDroolsModel>
    extends KiePMMLModel.Builder<T> {
        protected Builder(String prefix, PMML_MODEL pmmlMODEL, MINING_FUNCTION miningFunction, Supplier<T> supplier) {
            super(prefix, pmmlMODEL, miningFunction, supplier);
        }

        public Builder<T> withFieldTypeMap(Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap) {
            ((KiePMMLDroolsModel)this.toBuild).fieldTypeMap = fieldTypeMap;
            return this;
        }
    }
}

