/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.commons.factories;

import java.util.Map;
import org.dmg.pmml.SimplePredicate;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.ast.dsl.DescrFactory;
import org.drools.drl.ast.dsl.PackageDescrBuilder;
import org.kie.api.pmml.PMML4Result;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsAST;
import org.kie.pmml.models.drools.commons.factories.KiePMMLDescrRulesFactory;
import org.kie.pmml.models.drools.commons.factories.KiePMMLDescrTypesFactory;
import org.kie.pmml.models.drools.executor.KiePMMLStatusHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiePMMLDescrFactory {
    public static final String PMML4_RESULT = "PMML4Result";
    public static final String PMML4_RESULT_IDENTIFIER = "$pmml4Result";
    public static final String OUTPUTFIELDS_MAP = "Map";
    public static final String OUTPUTFIELDS_MAP_IDENTIFIER = "$outputFieldsMap";
    private static final Logger logger = LoggerFactory.getLogger((String)KiePMMLDescrFactory.class.getName());

    private KiePMMLDescrFactory() {
    }

    public static PackageDescr getBaseDescr(KiePMMLDroolsAST kiePMMLDroolsAST, String packageName) {
        logger.trace("getBaseDescr {} {}", (Object)kiePMMLDroolsAST, (Object)packageName);
        PackageDescrBuilder builder = DescrFactory.newPackage().name(packageName);
        builder.newImport().target(KiePMMLStatusHolder.class.getName());
        builder.newImport().target(SimplePredicate.class.getName());
        builder.newImport().target(PMML4Result.class.getName());
        builder.newImport().target(Map.class.getName());
        builder.newGlobal().identifier(PMML4_RESULT_IDENTIFIER).type(PMML4_RESULT);
        builder.newGlobal().identifier(OUTPUTFIELDS_MAP_IDENTIFIER).type(OUTPUTFIELDS_MAP);
        KiePMMLDescrTypesFactory.factory(builder).declareTypes(kiePMMLDroolsAST.getTypes());
        KiePMMLDescrRulesFactory.factory(builder).declareRules(kiePMMLDroolsAST.getRules());
        return (PackageDescr)builder.getDescr();
    }
}

