/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.provider;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dmg.pmml.Field;
import org.dmg.pmml.Model;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.util.StringUtils;
import org.kie.pmml.api.enums.DATA_TYPE;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.compiler.api.dto.CompilationDTO;
import org.kie.pmml.compiler.api.provider.ModelImplementationProvider;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsAST;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsType;
import org.kie.pmml.models.drools.ast.factories.KiePMMLDataDictionaryASTFactory;
import org.kie.pmml.models.drools.commons.factories.KiePMMLDescrFactory;
import org.kie.pmml.models.drools.commons.model.KiePMMLDroolsModel;
import org.kie.pmml.models.drools.commons.model.KiePMMLDroolsModelWithSources;
import org.kie.pmml.models.drools.dto.DroolsCompilationDTO;
import org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DroolsModelProvider<T extends Model, E extends KiePMMLDroolsModel>
implements ModelImplementationProvider<T, E> {
    private static final Logger logger = LoggerFactory.getLogger((String)DroolsModelProvider.class.getName());

    public Map<String, String> getSourcesMap(CompilationDTO<T> compilationDTO) {
        throw new KiePMMLException("DroolsModelProvider.getSourcesMap is not meant to be invoked");
    }

    public KiePMMLDroolsModelWithSources getKiePMMLModelWithSources(CompilationDTO<T> compilationDTO) {
        logger.trace("getKiePMMLModelWithSources {} {} {}", new Object[]{compilationDTO.getPackageName(), compilationDTO.getFields(), compilationDTO.getModel()});
        try {
            HashMap<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap = new HashMap<String, KiePMMLOriginalTypeGeneratedType>();
            KiePMMLDroolsAST kiePMMLDroolsAST = this.getKiePMMLDroolsASTCommon(compilationDTO.getFields(), compilationDTO.getModel(), fieldTypeMap);
            DroolsCompilationDTO<T> droolsCompilationDTO = DroolsCompilationDTO.fromCompilationDTO(compilationDTO, fieldTypeMap);
            Map<String, String> sourcesMap = this.getKiePMMLDroolsModelSourcesMap(droolsCompilationDTO);
            PackageDescr packageDescr = this.getPackageDescr(kiePMMLDroolsAST, compilationDTO.getPackageName());
            String pkgUUID = StringUtils.getPkgUUID((String)"gav", (String)compilationDTO.getPackageName());
            packageDescr.setPreferredPkgUUID(pkgUUID);
            return new KiePMMLDroolsModelWithSources(compilationDTO.getFileName(), compilationDTO.getModelName(), compilationDTO.getPackageName(), compilationDTO.getKieMiningFields(), compilationDTO.getKieOutputFields(), compilationDTO.getKieTargetFields(), sourcesMap, pkgUUID, packageDescr);
        }
        catch (Exception e) {
            throw new KiePMMLException((Throwable)e);
        }
    }

    public PackageDescr getPackageDescr(KiePMMLDroolsAST kiePMMLDroolsAST, String packageName) {
        return KiePMMLDescrFactory.getBaseDescr(kiePMMLDroolsAST, packageName);
    }

    public abstract KiePMMLDroolsAST getKiePMMLDroolsAST(List<Field<?>> var1, T var2, Map<String, KiePMMLOriginalTypeGeneratedType> var3, List<KiePMMLDroolsType> var4);

    public abstract Map<String, String> getKiePMMLDroolsModelSourcesMap(DroolsCompilationDTO<T> var1) throws IOException;

    protected KiePMMLDroolsAST getKiePMMLDroolsASTCommon(List<Field<?>> fields, T model, Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap) {
        List<KiePMMLDroolsType> types = fieldTypeMap.values().stream().map(kiePMMLOriginalTypeGeneratedType -> {
            String type = DATA_TYPE.byName((String)kiePMMLOriginalTypeGeneratedType.getOriginalType()).getMappedClass().getSimpleName();
            return new KiePMMLDroolsType(kiePMMLOriginalTypeGeneratedType.getGeneratedType(), type);
        }).collect(Collectors.toList());
        types.addAll(KiePMMLDataDictionaryASTFactory.factory(fieldTypeMap).declareTypes(fields));
        return this.getKiePMMLDroolsAST(fields, model, fieldTypeMap, types);
    }
}

