/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.clustering.model;

import java.util.List;
import org.kie.pmml.api.enums.Named;
import org.kie.pmml.models.clustering.model.KiePMMLClusteringField;
import org.kie.pmml.models.clustering.model.KiePMMLCompareFunction;

public enum KiePMMLAggregateFunction implements Named
{
    EUCLIDEAN("euclidean"),
    SQUARED_EUCLIDEAN("squaredEuclidean"),
    CHEBYCHEV("chebychev"),
    CITY_BLOCK("cityBlock"),
    MINKOWSKI("minkowski"),
    SIMPLE_MATCHING("simpleMatching"),
    JACCARD("jaccard"),
    TANIMOTO("tanimoto"),
    BINARY_SIMILARITY("binarySimilarity");

    private final String name;

    private KiePMMLAggregateFunction(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public double apply(List<KiePMMLClusteringField> fields, KiePMMLCompareFunction defaultCompare, Double[] inputs, double[] seeds, double adjust) {
        switch (this) {
            case EUCLIDEAN: {
                return KiePMMLAggregateFunction.euclidean(fields, defaultCompare, inputs, seeds, adjust);
            }
            case SQUARED_EUCLIDEAN: {
                return KiePMMLAggregateFunction.squaredEuclidean(fields, defaultCompare, inputs, seeds, adjust);
            }
            case CHEBYCHEV: 
            case CITY_BLOCK: 
            case MINKOWSKI: 
            case SIMPLE_MATCHING: 
            case JACCARD: 
            case TANIMOTO: 
            case BINARY_SIMILARITY: {
                throw new UnsupportedOperationException((Object)((Object)this) + " aggregate function not implemented");
            }
        }
        throw new IllegalStateException("Unknown aggregate function: " + (Object)((Object)this));
    }

    static double euclidean(List<KiePMMLClusteringField> fields, KiePMMLCompareFunction defaultCompare, Double[] inputs, double[] seeds, double adjust) {
        return Math.sqrt(KiePMMLAggregateFunction.squaredEuclidean(fields, defaultCompare, inputs, seeds, adjust));
    }

    static double squaredEuclidean(List<KiePMMLClusteringField> fields, KiePMMLCompareFunction defaultCompare, Double[] inputs, double[] seeds, double adjust) {
        double sum = 0.0;
        for (int i = 0; i < fields.size(); ++i) {
            if (inputs[i] == null) continue;
            KiePMMLClusteringField field = fields.get(i);
            double weight = field.getFieldWeight();
            KiePMMLCompareFunction compare = field.getCompareFunction().orElse(defaultCompare);
            sum += weight * Math.pow(compare.apply(field, inputs[i], seeds[i]), 2.0);
        }
        return sum * adjust;
    }
}

