/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.evaluator.assembler.command;

import org.kie.api.KieBase;
import org.kie.api.pmml.PMML4Result;
import org.kie.api.pmml.PMMLRequestData;
import org.kie.api.pmml.ParameterInfo;
import org.kie.api.runtime.Context;
import org.kie.internal.command.RegistryContext;
import org.kie.internal.pmml.PMMLCommandExecutor;
import org.kie.pmml.api.PMMLRuntimeFactory;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.runtime.PMMLContext;
import org.kie.pmml.api.runtime.PMMLRuntime;
import org.kie.pmml.commons.utils.ConverterTypeUtil;
import org.kie.pmml.evaluator.assembler.factories.PMMLRuntimeFactoryImpl;
import org.kie.pmml.evaluator.core.PMMLContextImpl;

public class PMMLCommandExecutorImpl
implements PMMLCommandExecutor {
    private static final PMMLRuntimeFactory PMML_RUNTIME_FACTORY = new PMMLRuntimeFactoryImpl();

    public PMML4Result execute(PMMLRequestData pmmlRequestData, Context context) {
        PMMLRequestData cleanedRequestData = this.getCleanedRequestData(pmmlRequestData);
        this.validate(cleanedRequestData);
        String pmmlFileName = cleanedRequestData.getSource();
        String pmmlModelName = cleanedRequestData.getModelName();
        PMMLRuntime pmmlRuntime = this.getPMMLRuntime(pmmlFileName, pmmlModelName, (KieBase)((RegistryContext)context).lookup(KieBase.class));
        return this.evaluate(cleanedRequestData, pmmlRuntime);
    }

    protected void validate(PMMLRequestData pmmlRequestData) {
        String toValidate = pmmlRequestData.getSource();
        if (toValidate == null || toValidate.isEmpty()) {
            throw new KiePMMLException("Missing required field 'source' with the PMML file name");
        }
        toValidate = pmmlRequestData.getModelName();
        if (toValidate == null || toValidate.isEmpty()) {
            throw new KiePMMLException("Missing required field 'modelName'");
        }
    }

    protected PMMLRequestData getCleanedRequestData(PMMLRequestData source) {
        PMMLRequestData toReturn = new PMMLRequestData();
        toReturn.setSource(source.getSource());
        toReturn.setCorrelationId(source.getCorrelationId());
        toReturn.setModelName(source.getModelName());
        source.getRequestParams().forEach(parameterInfo -> {
            Object value = ConverterTypeUtil.convert((Class)parameterInfo.getType(), (Object)parameterInfo.getValue());
            ParameterInfo toAdd = new ParameterInfo(parameterInfo.getCorrelationId(), parameterInfo.getName(), parameterInfo.getType(), value);
            toReturn.addRequestParam(toAdd);
        });
        return toReturn;
    }

    private PMML4Result evaluate(PMMLRequestData pmmlRequestData, PMMLRuntime pmmlRuntime) {
        String modelName = pmmlRequestData.getModelName();
        PMMLContextImpl pmmlContext = new PMMLContextImpl(pmmlRequestData);
        return pmmlRuntime.evaluate(modelName, (PMMLContext)pmmlContext);
    }

    private PMMLRuntime getPMMLRuntime(String pmmlFileName, String pmmlModelName, KieBase kieBase) {
        return PMML_RUNTIME_FACTORY.getPMMLRuntimeFromFileNameModelNameAndKieBase(pmmlFileName, pmmlModelName, kieBase);
    }
}

