/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.api.testutils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.RandomStringUtils;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Array;
import org.dmg.pmml.CompareFunction;
import org.dmg.pmml.ComparisonMeasure;
import org.dmg.pmml.ComplexScoreDistribution;
import org.dmg.pmml.CompoundPredicate;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Discretize;
import org.dmg.pmml.DiscretizeBin;
import org.dmg.pmml.Euclidean;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldColumnPair;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.InlineTable;
import org.dmg.pmml.Interval;
import org.dmg.pmml.InvalidValueTreatmentMethod;
import org.dmg.pmml.LinearNorm;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.Measure;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.MissingValueTreatmentMethod;
import org.dmg.pmml.Model;
import org.dmg.pmml.NormContinuous;
import org.dmg.pmml.NormDiscrete;
import org.dmg.pmml.OpType;
import org.dmg.pmml.OutlierTreatmentMethod;
import org.dmg.pmml.Output;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.PMML;
import org.dmg.pmml.ParameterField;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.ResultFeature;
import org.dmg.pmml.Row;
import org.dmg.pmml.ScoreDistribution;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.SimpleSetPredicate;
import org.dmg.pmml.TableLocator;
import org.dmg.pmml.Target;
import org.dmg.pmml.TargetValue;
import org.dmg.pmml.TextIndex;
import org.dmg.pmml.TextIndexNormalization;
import org.dmg.pmml.TransformationDictionary;
import org.dmg.pmml.Value;
import org.dmg.pmml.clustering.Cluster;
import org.dmg.pmml.clustering.ClusteringField;
import org.dmg.pmml.clustering.ClusteringModel;
import org.dmg.pmml.clustering.Comparisons;
import org.dmg.pmml.clustering.MissingValueWeights;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.Segment;
import org.dmg.pmml.mining.Segmentation;
import org.dmg.pmml.regression.CategoricalPredictor;
import org.dmg.pmml.regression.NumericPredictor;
import org.dmg.pmml.regression.PredictorTerm;
import org.dmg.pmml.regression.RegressionModel;
import org.dmg.pmml.regression.RegressionTable;
import org.jpmml.model.cells.InputCell;
import org.jpmml.model.cells.OutputCell;
import org.kie.pmml.api.enums.DATA_TYPE;
import org.kie.pmml.api.enums.Named;
import org.kie.pmml.api.enums.RESULT_FEATURE;
import org.kie.pmml.compiler.api.mocks.TestModel;

public class PMMLModelTestUtils {
    private PMMLModelTestUtils() {
    }

    public static PMML getPMMLWithRandomTestModel() {
        PMML toReturn = new PMML();
        DataDictionary dataDictionary = PMMLModelTestUtils.getRandomDataDictionary();
        toReturn.setDataDictionary(dataDictionary);
        toReturn.addModels(new Model[]{PMMLModelTestUtils.getRandomTestModel(dataDictionary)});
        return toReturn;
    }

    public static PMML getPMMLWithMiningRandomTestModel() {
        PMML toReturn = new PMML();
        DataDictionary dataDictionary = PMMLModelTestUtils.getRandomDataDictionary();
        toReturn.setDataDictionary(dataDictionary);
        toReturn.addModels(new Model[]{PMMLModelTestUtils.getRandomMiningModel(dataDictionary)});
        return toReturn;
    }

    public static DataDictionary getDataDictionary(List<DataField> dataFields) {
        DataDictionary toReturn = new DataDictionary();
        toReturn.addDataFields(dataFields.toArray(new DataField[0]));
        return toReturn;
    }

    public static TransformationDictionary getTransformationDictionary() {
        return new TransformationDictionary();
    }

    public static MiningSchema getMiningSchema(List<MiningField> miningFields) {
        MiningSchema toReturn = new MiningSchema();
        toReturn.addMiningFields(miningFields.toArray(new MiningField[0]));
        return toReturn;
    }

    public static DataDictionary getRandomDataDictionary() {
        DataDictionary toReturn = new DataDictionary();
        IntStream.range(0, new Random().nextInt(3) + 2).forEach(i -> toReturn.addDataFields(new DataField[]{PMMLModelTestUtils.getRandomDataField()}));
        return toReturn;
    }

    public static TransformationDictionary getRandomTransformationDictionary() {
        TransformationDictionary toReturn = new TransformationDictionary();
        IntStream.range(0, 3).forEach(i -> {
            toReturn.addDerivedFields(new DerivedField[]{PMMLModelTestUtils.getDerivedField("DerivedField-" + i)});
            toReturn.addDefineFunctions(new DefineFunction[]{PMMLModelTestUtils.getDefineFunction("DefineFunction-" + i)});
        });
        return toReturn;
    }

    public static LocalTransformations getRandomLocalTransformations() {
        LocalTransformations toReturn = new LocalTransformations();
        IntStream.range(0, 3).forEach(i -> toReturn.addDerivedFields(new DerivedField[]{PMMLModelTestUtils.getDerivedField("DerivedField-" + i)}));
        return toReturn;
    }

    public static MiningSchema getRandomMiningSchema() {
        MiningSchema toReturn = new MiningSchema();
        IntStream.range(0, new Random().nextInt(3) + 2).forEach(i -> toReturn.addMiningFields(new MiningField[]{PMMLModelTestUtils.getRandomMiningField()}));
        return toReturn;
    }

    public static Output getRandomOutput() {
        Output toReturn = new Output();
        IntStream.range(0, new Random().nextInt(3) + 2).forEach(i -> toReturn.addOutputFields(new OutputField[]{PMMLModelTestUtils.getRandomOutputField()}));
        return toReturn;
    }

    public static TestModel getRandomTestModel(DataDictionary dataDictionary) {
        TestModel toReturn = new TestModel();
        List dataFields = dataDictionary.getDataFields();
        MiningSchema miningSchema = new MiningSchema();
        IntStream.range(0, dataFields.size() - 1).forEach(i -> {
            DataField dataField = (DataField)dataFields.get(i);
            MiningField miningField = new MiningField();
            miningField.setName(dataField.getName());
            miningField.setUsageType(MiningField.UsageType.ACTIVE);
            miningSchema.addMiningFields(new MiningField[]{miningField});
        });
        DataField lastDataField = (DataField)dataFields.get(dataFields.size() - 1);
        MiningField predictedMiningField = new MiningField();
        predictedMiningField.setName(lastDataField.getName());
        predictedMiningField.setUsageType(MiningField.UsageType.PREDICTED);
        miningSchema.addMiningFields(new MiningField[]{predictedMiningField});
        Output output = new Output();
        OutputField outputField = new OutputField();
        outputField.setName("OUTPUT_" + lastDataField.getName());
        outputField.setDataType(lastDataField.getDataType());
        outputField.setOpType(PMMLModelTestUtils.getRandomOpType());
        toReturn.setModelName(RandomStringUtils.random((int)6, (boolean)true, (boolean)false));
        toReturn.setMiningSchema(miningSchema);
        toReturn.setOutput(output);
        return toReturn;
    }

    public static MiningModel getRandomMiningModel(DataDictionary dataDictionary) {
        MiningModel toReturn = new MiningModel();
        List dataFields = dataDictionary.getDataFields();
        MiningSchema miningSchema = new MiningSchema();
        IntStream.range(0, dataFields.size() - 1).forEach(i -> {
            DataField dataField = (DataField)dataFields.get(i);
            MiningField miningField = new MiningField();
            miningField.setName(dataField.getName());
            miningField.setUsageType(MiningField.UsageType.ACTIVE);
            miningSchema.addMiningFields(new MiningField[]{miningField});
        });
        DataField lastDataField = (DataField)dataFields.get(dataFields.size() - 1);
        MiningField predictedMiningField = new MiningField();
        predictedMiningField.setName(lastDataField.getName());
        predictedMiningField.setUsageType(MiningField.UsageType.PREDICTED);
        miningSchema.addMiningFields(new MiningField[]{predictedMiningField});
        Output output = new Output();
        OutputField outputField = new OutputField();
        outputField.setName("OUTPUT_" + lastDataField.getName());
        outputField.setDataType(lastDataField.getDataType());
        outputField.setOpType(PMMLModelTestUtils.getRandomOpType());
        toReturn.setModelName(RandomStringUtils.random((int)6, (boolean)true, (boolean)false));
        toReturn.setMiningSchema(miningSchema);
        toReturn.setOutput(output);
        TestModel testModel = PMMLModelTestUtils.getRandomTestModel(dataDictionary);
        Segment segment = new Segment();
        segment.setModel((Model)testModel);
        Segmentation segmentation = new Segmentation();
        segmentation.addSegments(new Segment[]{segment});
        toReturn.setSegmentation(segmentation);
        return toReturn;
    }

    public static DiscretizeBin getRandomDiscretizeBin() {
        Interval interval = PMMLModelTestUtils.getRandomInterval();
        DiscretizeBin toReturn = new DiscretizeBin();
        toReturn.setInterval(interval);
        toReturn.setBinValue((Object)RandomStringUtils.random((int)6, (boolean)true, (boolean)false));
        return toReturn;
    }

    public static Interval getRandomInterval() {
        Random random = new Random();
        Integer leftMargin = random.nextInt(100) / 10;
        Double rightMargin = ((Number)leftMargin).doubleValue() + (double)(random.nextInt(50) / 10);
        Interval toReturn = new Interval();
        toReturn.setLeftMargin((Number)leftMargin);
        toReturn.setRightMargin((Number)rightMargin);
        toReturn.setClosure(PMMLModelTestUtils.getRandomClosure());
        return toReturn;
    }

    public static RegressionModel getRegressionModel(String modelName, MiningFunction miningFunction, MiningSchema miningSchema, List<RegressionTable> regressionTables) {
        RegressionModel toReturn = new RegressionModel();
        toReturn.setModelName(modelName);
        toReturn.setMiningFunction(miningFunction);
        toReturn.setMiningSchema(miningSchema);
        toReturn.addRegressionTables(regressionTables.toArray(new RegressionTable[0]));
        return toReturn;
    }

    public static RegressionTable getRegressionTable(List<CategoricalPredictor> categoricalPredictors, List<NumericPredictor> numericPredictors, List<PredictorTerm> predictorTerms, double intercept, Object targetCategory) {
        RegressionTable toReturn = new RegressionTable();
        toReturn.setIntercept((Number)intercept);
        toReturn.setTargetCategory(targetCategory);
        toReturn.addCategoricalPredictors(categoricalPredictors.toArray(new CategoricalPredictor[0]));
        toReturn.addNumericPredictors(numericPredictors.toArray(new NumericPredictor[0]));
        toReturn.addPredictorTerms(predictorTerms.toArray(new PredictorTerm[0]));
        return toReturn;
    }

    public static CategoricalPredictor getCategoricalPredictor(String name, double value, double coefficient) {
        CategoricalPredictor toReturn = new CategoricalPredictor();
        toReturn.setField(name);
        toReturn.setValue((Object)value);
        toReturn.setCoefficient((Number)coefficient);
        return toReturn;
    }

    public static NumericPredictor getNumericPredictor(String name, int exponent, double coefficient) {
        NumericPredictor toReturn = new NumericPredictor();
        toReturn.setField(name);
        toReturn.setExponent(Integer.valueOf(exponent));
        toReturn.setCoefficient((Number)coefficient);
        return toReturn;
    }

    public static PredictorTerm getPredictorTerm(String name, double coefficient, List<String> fieldRefNames) {
        PredictorTerm toReturn = new PredictorTerm();
        toReturn.setName(name);
        toReturn.setCoefficient((Number)coefficient);
        toReturn.addFieldRefs((FieldRef[])fieldRefNames.stream().map(PMMLModelTestUtils::getFieldRef).toArray(FieldRef[]::new));
        return toReturn;
    }

    public static ClusteringModel getClusteringModel(String modelName, MiningFunction miningFunction, MiningSchema miningSchema, List<ClusteringField> clusteringFields, List<Cluster> clusters) {
        ClusteringModel toReturn = new ClusteringModel();
        toReturn.setModelName(modelName);
        toReturn.setMiningFunction(miningFunction);
        toReturn.setMiningSchema(miningSchema);
        toReturn.addClusteringFields(clusteringFields.toArray(new ClusteringField[0]));
        toReturn.addClusters(clusters.toArray(new Cluster[0]));
        toReturn.setModelClass(PMMLModelTestUtils.getRandomModelClass());
        toReturn.setComparisonMeasure(PMMLModelTestUtils.getRandomComparisonMeasure());
        toReturn.setMissingValueWeights(PMMLModelTestUtils.getRandomMissingValueWeights());
        return toReturn;
    }

    public static DataField getDataField(String fieldName, OpType opType) {
        DataField toReturn = new DataField();
        toReturn.setName(fieldName);
        toReturn.setOpType(opType);
        return toReturn;
    }

    public static DataField getDataField(String fieldName, OpType opType, DataType dataType) {
        DataField toReturn = PMMLModelTestUtils.getDataField(fieldName, opType);
        toReturn.setDataType(dataType);
        return toReturn;
    }

    public static MiningField getMiningField(String fieldName, MiningField.UsageType usageType) {
        MiningField toReturn = PMMLModelTestUtils.getRandomMiningField();
        toReturn.setName(fieldName);
        toReturn.setUsageType(usageType);
        return toReturn;
    }

    public static Target getTarget(String fieldTarget, OpType opType) {
        Target toReturn = new Target();
        toReturn.setField(fieldTarget);
        toReturn.setOpType(opType);
        return toReturn;
    }

    public static DefineFunction getDefineFunction(String functionName) {
        DefineFunction toReturn = new DefineFunction();
        toReturn.setName(functionName);
        toReturn.setDataType(PMMLModelTestUtils.getRandomDataType());
        toReturn.setOpType(PMMLModelTestUtils.getRandomOpType());
        Constant expression = new Constant((Object)5);
        expression.setDataType(DataType.INTEGER);
        toReturn.setExpression((Expression)expression);
        IntStream.range(0, 3).forEach(i -> toReturn.addParameterFields(new ParameterField[]{PMMLModelTestUtils.getParameterField("ParameterField-" + i)}));
        return toReturn;
    }

    public static DerivedField getDerivedField(String fieldName) {
        DerivedField toReturn = new DerivedField();
        toReturn.setName(fieldName);
        toReturn.setDataType(PMMLModelTestUtils.getRandomDataType());
        toReturn.setOpType(PMMLModelTestUtils.getRandomOpType());
        Constant expression = new Constant((Object)5);
        expression.setDataType(DataType.INTEGER);
        toReturn.setExpression((Expression)expression);
        toReturn.setDisplayName("Display-" + fieldName);
        return toReturn;
    }

    public static ComparisonMeasure getRandomComparisonMeasure() {
        ComparisonMeasure toReturn = new ComparisonMeasure();
        toReturn.setCompareFunction(PMMLModelTestUtils.getRandomCompareFunction());
        toReturn.setKind(PMMLModelTestUtils.getRandomKind());
        toReturn.setMeasure(PMMLModelTestUtils.getRandomMeasure());
        return toReturn;
    }

    public static Measure getRandomMeasure() {
        return new Euclidean();
    }

    public static DataField getRandomDataField() {
        DataField toReturn = new DataField();
        toReturn.setName(RandomStringUtils.random((int)6, (boolean)true, (boolean)false));
        toReturn.setDataType(PMMLModelTestUtils.getRandomDataType());
        toReturn.setOpType(PMMLModelTestUtils.getRandomOpType());
        IntStream.range(0, 3).forEach(i -> {
            toReturn.addValues(new Value[]{PMMLModelTestUtils.getRandomValue(toReturn.getDataType())});
            toReturn.addIntervals(new Interval[]{PMMLModelTestUtils.getRandomInterval()});
        });
        return toReturn;
    }

    public static MiningField getRandomMiningField(DataField dataField) {
        Random random = new Random();
        MiningField toReturn = PMMLModelTestUtils.getRandomMiningField();
        DataType dataType = dataField.getDataType();
        toReturn.setName(dataField.getName());
        toReturn.setInvalidValueReplacement((Object)PMMLModelTestUtils.getRandomObject(dataType).toString());
        toReturn.setMissingValueReplacement((Object)PMMLModelTestUtils.getRandomObject(dataType).toString());
        toReturn.setImportance((Number)random.nextInt(10));
        toReturn.setLowValue((Number)random.nextInt(10));
        toReturn.setHighValue((Number)(toReturn.getLowValue().intValue() + random.nextInt(30)));
        toReturn.setUsageType(PMMLModelTestUtils.getRandomUsageType());
        toReturn.setOpType(PMMLModelTestUtils.getRandomOpType());
        return toReturn;
    }

    public static MiningField getRandomMiningField() {
        Random random = new Random();
        MiningField toReturn = new MiningField(RandomStringUtils.random((int)6, (boolean)true, (boolean)false));
        toReturn.setInvalidValueTreatment(PMMLModelTestUtils.getRandomInvalidValueTreatmentMethod());
        toReturn.setMissingValueTreatment(PMMLModelTestUtils.getRandomMissingValueTreatmentMethod());
        toReturn.setOutlierTreatment(PMMLModelTestUtils.getRandomOutlierTreatmentMethod());
        DataType dataType = PMMLModelTestUtils.getRandomDataType();
        toReturn.setInvalidValueReplacement((Object)PMMLModelTestUtils.getRandomObject(dataType).toString());
        toReturn.setMissingValueReplacement((Object)PMMLModelTestUtils.getRandomObject(dataType).toString());
        toReturn.setImportance((Number)random.nextInt(10));
        toReturn.setLowValue((Number)random.nextInt(10));
        toReturn.setHighValue((Number)(toReturn.getLowValue().intValue() + random.nextInt(30)));
        toReturn.setUsageType(PMMLModelTestUtils.getRandomUsageType());
        toReturn.setOpType(PMMLModelTestUtils.getRandomOpType());
        return toReturn;
    }

    public static OutputField getRandomOutputField(DataField dataField) {
        OutputField toReturn = PMMLModelTestUtils.getRandomOutputField();
        toReturn.setName(dataField.getName());
        toReturn.setDataType(dataField.getDataType());
        return toReturn;
    }

    public static OutputField getRandomOutputField() {
        String fieldName = RandomStringUtils.random((int)6, (boolean)true, (boolean)false);
        OutputField toReturn = new OutputField();
        toReturn.setName(fieldName);
        toReturn.setOpType(PMMLModelTestUtils.getRandomOpType());
        toReturn.setDataType(PMMLModelTestUtils.getRandomDataType());
        toReturn.setValue((Object)PMMLModelTestUtils.getRandomValue(toReturn.getDataType()));
        fieldName = RandomStringUtils.random((int)6, (boolean)true, (boolean)false);
        toReturn.setTargetField(fieldName);
        toReturn.setResultFeature(PMMLModelTestUtils.getRandomResultFeature());
        toReturn.setExpression((Expression)PMMLModelTestUtils.getRandomConstant());
        return toReturn;
    }

    public static Target getRandomTarget() {
        Random random = new Random();
        Target toReturn = new Target();
        toReturn.setField(RandomStringUtils.random((int)6, (boolean)true, (boolean)false));
        toReturn.setOpType(PMMLModelTestUtils.getRandomOpType());
        toReturn.setMax((Number)random.nextInt(234));
        toReturn.setMin((Number)random.nextInt(23));
        toReturn.setCastInteger(PMMLModelTestUtils.getRandomCastInteger());
        toReturn.setRescaleConstant((Number)random.nextInt(234));
        toReturn.setRescaleFactor((Number)random.nextInt(234));
        IntStream.range(0, 3).forEach(i -> toReturn.addTargetValues(new TargetValue[]{PMMLModelTestUtils.getRandomTargetValue()}));
        return toReturn;
    }

    public static TargetValue getRandomTargetValue() {
        Random random = new Random();
        TargetValue toReturn = new TargetValue();
        toReturn.setValue((Object)random.nextDouble());
        toReturn.setDisplayValue(RandomStringUtils.random((int)6, (boolean)true, (boolean)false));
        toReturn.setDefaultValue((Number)Float.valueOf(random.nextFloat()));
        toReturn.setPriorProbability((Number)((double)random.nextInt(100) / 13.0));
        return toReturn;
    }

    public static FieldColumnPair getRandomFieldColumnPair() {
        FieldColumnPair toReturn = new FieldColumnPair();
        toReturn.setField(RandomStringUtils.random((int)6, (boolean)true, (boolean)false));
        toReturn.setColumn(RandomStringUtils.random((int)6, (boolean)true, (boolean)false));
        return toReturn;
    }

    public static Cluster getRandomCluster() {
        Random random = new Random();
        Cluster toReturn = new Cluster();
        toReturn.setName(RandomStringUtils.random((int)6, (boolean)true, (boolean)false));
        toReturn.setId(String.valueOf(random.nextInt()));
        return toReturn;
    }

    public static ClusteringField getRandomClusteringField() {
        Random random = new Random();
        ClusteringField toReturn = new ClusteringField();
        toReturn.setCenterField(PMMLModelTestUtils.getRandomClusteringFieldCenterField());
        toReturn.setField(RandomStringUtils.random((int)6, (boolean)true, (boolean)false));
        toReturn.setCompareFunction(PMMLModelTestUtils.getRandomCompareFunction());
        toReturn.setFieldWeight((Number)random.nextDouble());
        toReturn.setComparisons(PMMLModelTestUtils.getRandomComparisons());
        toReturn.setSimilarityScale((Number)random.nextDouble());
        return toReturn;
    }

    public static Comparisons getRandomComparisons() {
        Comparisons toReturn = new Comparisons();
        return toReturn;
    }

    public static Apply getRandomApply() {
        Apply toReturn = new Apply();
        toReturn.setFunction(RandomStringUtils.random((int)6, (boolean)true, (boolean)false));
        toReturn.setDefaultValue((Object)RandomStringUtils.random((int)6, (boolean)true, (boolean)false));
        toReturn.setMapMissingTo((Object)RandomStringUtils.random((int)6, (boolean)true, (boolean)false));
        toReturn.setInvalidValueTreatment(PMMLModelTestUtils.getRandomInvalidValueTreatmentMethod());
        toReturn.addExpressions(new Expression[]{PMMLModelTestUtils.getRandomConstant()});
        toReturn.addExpressions(new Expression[]{PMMLModelTestUtils.getRandomDiscretize()});
        toReturn.addExpressions(new Expression[]{PMMLModelTestUtils.getRandomFieldRef()});
        return toReturn;
    }

    public static Constant getRandomConstant() {
        Constant toReturn = new Constant();
        toReturn.setDataType(PMMLModelTestUtils.getRandomDataType());
        toReturn.setValue(PMMLModelTestUtils.getRandomObject(toReturn.getDataType()));
        return toReturn;
    }

    public static Discretize getRandomDiscretize() {
        Discretize toReturn = new Discretize();
        toReturn.setDataType(PMMLModelTestUtils.getRandomDataType());
        toReturn.setDefaultValue((Object)RandomStringUtils.random((int)6, (boolean)true, (boolean)false));
        toReturn.setField(RandomStringUtils.random((int)6, (boolean)true, (boolean)false));
        toReturn.setMapMissingTo((Object)RandomStringUtils.random((int)6, (boolean)true, (boolean)false));
        IntStream.range(0, 3).forEach(i -> toReturn.addDiscretizeBins(new DiscretizeBin[]{PMMLModelTestUtils.getRandomDiscretizeBin()}));
        return toReturn;
    }

    public static FieldRef getRandomFieldRef() {
        FieldRef toReturn = new FieldRef();
        toReturn.setField(RandomStringUtils.random((int)6, (boolean)true, (boolean)false));
        toReturn.setMapMissingTo((Object)RandomStringUtils.random((int)6, (boolean)true, (boolean)false));
        return toReturn;
    }

    public static MapValues getRandomMapValues() {
        MapValues toReturn = new MapValues();
        toReturn.setDataType(PMMLModelTestUtils.getRandomDataType());
        toReturn.setDefaultValue(PMMLModelTestUtils.getRandomObject(toReturn.getDataType()));
        toReturn.setMapMissingTo((Object)RandomStringUtils.random((int)6, (boolean)true, (boolean)false));
        toReturn.setOutputColumn(RandomStringUtils.random((int)6, (boolean)true, (boolean)false));
        toReturn.setInlineTable(PMMLModelTestUtils.getRandomInlineTableWithCells());
        toReturn.setTableLocator(PMMLModelTestUtils.getRandomTableLocator());
        return toReturn;
    }

    public static MissingValueWeights getRandomMissingValueWeights() {
        MissingValueWeights toReturn = new MissingValueWeights();
        return toReturn;
    }

    public static NormContinuous getRandomNormContinuous() {
        Random random = new Random();
        double mapMissingTo = random.nextInt(100) / 10;
        NormContinuous toReturn = new NormContinuous();
        IntStream.range(0, 3).forEach(i -> toReturn.addLinearNorms(new LinearNorm[]{PMMLModelTestUtils.getRandomLinearNorm()}));
        toReturn.setField(RandomStringUtils.random((int)6, (boolean)true, (boolean)false));
        toReturn.setOutliers(PMMLModelTestUtils.getRandomOutlierTreatmentMethod());
        toReturn.setMapMissingTo((Number)mapMissingTo);
        return toReturn;
    }

    public static NormDiscrete getRandomNormDiscrete() {
        NormDiscrete toReturn = new NormDiscrete();
        toReturn.setField(RandomStringUtils.random((int)6, (boolean)true, (boolean)false));
        toReturn.setValue(PMMLModelTestUtils.getRandomObject(DataType.INTEGER));
        toReturn.setMapMissingTo((Number)PMMLModelTestUtils.getRandomObject(DataType.INTEGER));
        toReturn.setMethod(PMMLModelTestUtils.getRandomMethod());
        return toReturn;
    }

    public static TextIndex getRandomTextIndex() {
        Random random = new Random();
        TextIndex toReturn = new TextIndex();
        toReturn.setField(RandomStringUtils.random((int)6, (boolean)true, (boolean)false));
        toReturn.setExpression((Expression)PMMLModelTestUtils.getRandomFieldRef());
        toReturn.setLocalTermWeights(PMMLModelTestUtils.getRandomLocalTermWeights());
        toReturn.setWordSeparatorCharacterRE(RandomStringUtils.random((int)1, (boolean)true, (boolean)false));
        toReturn.setTokenize(Boolean.valueOf(true));
        toReturn.setCaseSensitive(Boolean.valueOf(false));
        toReturn.setMaxLevenshteinDistance(Integer.valueOf(random.nextInt(10)));
        toReturn.setTextField(RandomStringUtils.random((int)6, (boolean)true, (boolean)false));
        IntStream.range(0, 3).forEach(i -> toReturn.addTextIndexNormalizations(new TextIndexNormalization[]{PMMLModelTestUtils.getRandomTextIndexNormalization()}));
        return toReturn;
    }

    public static LinearNorm getRandomLinearNorm() {
        Random random = new Random();
        double orig = random.nextInt(100) / 10;
        double norm = random.nextInt(100) / 10;
        return new LinearNorm((Number)orig, (Number)norm);
    }

    public static ParameterField getParameterField(String fieldName) {
        ParameterField toReturn = new ParameterField(fieldName);
        toReturn.setDataType(PMMLModelTestUtils.getRandomDataType());
        toReturn.setOpType(PMMLModelTestUtils.getRandomOpType());
        toReturn.setDisplayName("Display-" + fieldName);
        return toReturn;
    }

    public static ParameterField getParameterField(String fieldName, DataType dataType) {
        ParameterField toReturn = new ParameterField(fieldName);
        toReturn.setDataType(dataType);
        return toReturn;
    }

    public static List<ParameterField> getParameterFields() {
        DATA_TYPE[] dataTypes = DATA_TYPE.values();
        ArrayList<ParameterField> toReturn = new ArrayList<ParameterField>();
        for (int i = 0; i < dataTypes.length; ++i) {
            DataType dataType = DataType.fromValue((String)dataTypes[i].getName());
            ParameterField toAdd = PMMLModelTestUtils.getParameterField(dataType.value().toUpperCase(), dataType);
            toReturn.add(toAdd);
        }
        return toReturn;
    }

    public static List<DataType> getDataTypes() {
        return PMMLModelTestUtils.getEnumList((Named[])DATA_TYPE.values(), DataType.class);
    }

    public static List<ResultFeature> getResultFeature() {
        return PMMLModelTestUtils.getEnumList((Named[])RESULT_FEATURE.values(), ResultFeature.class);
    }

    public static SimplePredicate getSimplePredicate(String predicateName, Object value, SimplePredicate.Operator operator) {
        String fieldName = predicateName;
        SimplePredicate toReturn = new SimplePredicate();
        toReturn.setField(fieldName);
        toReturn.setOperator(operator);
        toReturn.setValue(value);
        return toReturn;
    }

    public static CompoundPredicate getCompoundPredicate(List<SimplePredicate> simplePredicates, int counter) {
        CompoundPredicate toReturn = new CompoundPredicate();
        toReturn.setBooleanOperator(PMMLModelTestUtils.getRandomCompoundPredicateAndOrOperator(counter));
        toReturn.getPredicates().addAll(PMMLModelTestUtils.getRandomSimplePredicates(simplePredicates));
        return toReturn;
    }

    public static SimpleSetPredicate getSimpleSetPredicate(String predicateName, Array.Type arrayType, List<String> values, SimpleSetPredicate.BooleanOperator booleanOperator) {
        String fieldName = predicateName;
        SimpleSetPredicate toReturn = new SimpleSetPredicate();
        toReturn.setField(fieldName);
        toReturn.setBooleanOperator(booleanOperator);
        Array array = PMMLModelTestUtils.getArray(arrayType, values);
        toReturn.setArray(array);
        return toReturn;
    }

    public static Array getArray(Array.Type arrayType, List<String> values) {
        String arrayString = String.join((CharSequence)" ", values);
        Array toReturn = new Array(arrayType, (Object)arrayString);
        toReturn.setN(Integer.valueOf(values.size()));
        return toReturn;
    }

    public static FieldRef getFieldRef(String fieldName) {
        return new FieldRef(fieldName);
    }

    public static Object getRandomObject(DataType dataType) {
        switch (dataType) {
            case INTEGER: 
            case DATE_DAYS_SINCE_0: 
            case DATE_DAYS_SINCE_1960: 
            case DATE_DAYS_SINCE_1970: 
            case DATE_DAYS_SINCE_1980: 
            case DATE_DAYS_SINCE_1990: 
            case DATE_DAYS_SINCE_2000: 
            case DATE_DAYS_SINCE_2010: 
            case DATE_DAYS_SINCE_2020: {
                return new Random().nextInt(40);
            }
            case DOUBLE: {
                return new Random().nextDouble();
            }
            case BOOLEAN: {
                return new Random().nextBoolean();
            }
            case STRING: {
                return RandomStringUtils.random((int)6, (boolean)true, (boolean)false);
            }
            case FLOAT: {
                return Float.valueOf(new Random().nextFloat());
            }
            case DATE: 
            case TIME: 
            case DATE_TIME: {
                return new Date();
            }
            case TIME_SECONDS: 
            case DATE_TIME_SECONDS_SINCE_0: 
            case DATE_TIME_SECONDS_SINCE_1960: 
            case DATE_TIME_SECONDS_SINCE_1970: 
            case DATE_TIME_SECONDS_SINCE_1980: 
            case DATE_TIME_SECONDS_SINCE_1990: 
            case DATE_TIME_SECONDS_SINCE_2000: 
            case DATE_TIME_SECONDS_SINCE_2010: 
            case DATE_TIME_SECONDS_SINCE_2020: {
                return new Random().nextLong();
            }
        }
        return new Random().nextInt();
    }

    public static Value getRandomValue(DataType dataType) {
        Value toReturn = PMMLModelTestUtils.getRandomValue();
        toReturn.setValue(PMMLModelTestUtils.getRandomObject(dataType));
        return toReturn;
    }

    public static Value getRandomValue() {
        Value toReturn = new Value();
        toReturn.setValue(PMMLModelTestUtils.getRandomObject(PMMLModelTestUtils.getRandomDataType()));
        toReturn.setDisplayValue(RandomStringUtils.random((int)6, (boolean)true, (boolean)false));
        toReturn.setProperty(PMMLModelTestUtils.getRandomProperty());
        return toReturn;
    }

    public static TextIndexNormalization getRandomTextIndexNormalization() {
        Random random = new Random();
        TextIndexNormalization toReturn = new TextIndexNormalization();
        toReturn.setCaseSensitive(Boolean.valueOf(false));
        toReturn.setInlineTable(PMMLModelTestUtils.getRandomInlineTableWithCells());
        toReturn.setWordSeparatorCharacterRE(RandomStringUtils.random((int)1, (boolean)true, (boolean)false));
        toReturn.setTokenize(Boolean.valueOf(true));
        toReturn.setCaseSensitive(Boolean.valueOf(false));
        toReturn.setMaxLevenshteinDistance(Integer.valueOf(random.nextInt(10)));
        toReturn.setOutField(RandomStringUtils.random((int)1, (boolean)true, (boolean)false));
        toReturn.setTableLocator(PMMLModelTestUtils.getRandomTableLocator());
        toReturn.setInField(RandomStringUtils.random((int)1, (boolean)true, (boolean)false));
        toReturn.setRecursive(Boolean.valueOf(false));
        toReturn.setRegexField(RandomStringUtils.random((int)1, (boolean)true, (boolean)false));
        return toReturn;
    }

    public static TableLocator getRandomTableLocator() {
        return new TableLocator();
    }

    public static InlineTable getRandomInlineTableWithCells() {
        InlineTable toReturn = new InlineTable();
        IntStream.range(0, 3).forEach(i -> toReturn.addRows(new Row[]{PMMLModelTestUtils.getRandomRowWithCells()}));
        return toReturn;
    }

    public static Row getRandomRow() {
        Row toReturn = new Row();
        toReturn.addContent(new Object[]{RandomStringUtils.random((int)6, (boolean)true, (boolean)false)});
        return toReturn;
    }

    public static Row getRandomRowWithCells() {
        Row toReturn = new Row();
        toReturn.addContent(new Object[]{new InputCell((Object)RandomStringUtils.random((int)6, (boolean)true, (boolean)false))});
        toReturn.addContent(new Object[]{new OutputCell((Object)RandomStringUtils.random((int)6, (boolean)true, (boolean)false))});
        return toReturn;
    }

    public static Array.Type getArrayType(DataType dataType) {
        switch (dataType) {
            case INTEGER: {
                return Array.Type.INT;
            }
            case STRING: {
                return Array.Type.STRING;
            }
        }
        return Array.Type.REAL;
    }

    public static Array.Type getRandomArrayType() {
        return (Array.Type)PMMLModelTestUtils.getRandomEnum((Enum[])Array.Type.values());
    }

    public static CompoundPredicate.BooleanOperator getRandomCompoundPredicateBooleanOperator() {
        return (CompoundPredicate.BooleanOperator)PMMLModelTestUtils.getRandomEnum((Enum[])CompoundPredicate.BooleanOperator.values());
    }

    public static Target.CastInteger getRandomCastInteger() {
        return (Target.CastInteger)PMMLModelTestUtils.getRandomEnum((Enum[])Target.CastInteger.values());
    }

    public static ClusteringField.CenterField getRandomClusteringFieldCenterField() {
        return (ClusteringField.CenterField)PMMLModelTestUtils.getRandomEnum((Enum[])ClusteringField.CenterField.values());
    }

    public static CompareFunction getRandomCompareFunction() {
        return (CompareFunction)PMMLModelTestUtils.getRandomEnum((Enum[])CompareFunction.values());
    }

    public static Interval.Closure getRandomClosure() {
        return (Interval.Closure)PMMLModelTestUtils.getRandomEnum((Enum[])Interval.Closure.values());
    }

    public static DataType getRandomDataType() {
        List<DataType> dataTypes = PMMLModelTestUtils.getDataTypes();
        return (DataType)PMMLModelTestUtils.getRandomEnum((Enum[])dataTypes.toArray(new DataType[0]));
    }

    public static InvalidValueTreatmentMethod getRandomInvalidValueTreatmentMethod() {
        return (InvalidValueTreatmentMethod)PMMLModelTestUtils.getRandomEnum((Enum[])InvalidValueTreatmentMethod.values());
    }

    public static ComparisonMeasure.Kind getRandomKind() {
        return (ComparisonMeasure.Kind)PMMLModelTestUtils.getRandomEnum((Enum[])ComparisonMeasure.Kind.values());
    }

    public static TextIndex.LocalTermWeights getRandomLocalTermWeights() {
        return (TextIndex.LocalTermWeights)PMMLModelTestUtils.getRandomEnum((Enum[])TextIndex.LocalTermWeights.values());
    }

    public static NormDiscrete.Method getRandomMethod() {
        return (NormDiscrete.Method)PMMLModelTestUtils.getRandomEnum((Enum[])NormDiscrete.Method.values());
    }

    public static MissingValueTreatmentMethod getRandomMissingValueTreatmentMethod() {
        return (MissingValueTreatmentMethod)PMMLModelTestUtils.getRandomEnum((Enum[])MissingValueTreatmentMethod.values());
    }

    public static ClusteringModel.ModelClass getRandomModelClass() {
        return (ClusteringModel.ModelClass)PMMLModelTestUtils.getRandomEnum((Enum[])ClusteringModel.ModelClass.values());
    }

    public static OpType getRandomOpType() {
        return (OpType)PMMLModelTestUtils.getRandomEnum((Enum[])OpType.values());
    }

    public static OutlierTreatmentMethod getRandomOutlierTreatmentMethod() {
        return (OutlierTreatmentMethod)PMMLModelTestUtils.getRandomEnum((Enum[])OutlierTreatmentMethod.values());
    }

    public static Value.Property getRandomProperty() {
        return (Value.Property)PMMLModelTestUtils.getRandomEnum((Enum[])Value.Property.values());
    }

    public static ResultFeature getRandomResultFeature() {
        List<ResultFeature> resultFeatures = PMMLModelTestUtils.getResultFeature();
        return (ResultFeature)PMMLModelTestUtils.getRandomEnum((Enum[])resultFeatures.toArray(new ResultFeature[0]));
    }

    public static SimplePredicate.Operator getRandomSimplePredicateOperator() {
        return (SimplePredicate.Operator)PMMLModelTestUtils.getRandomEnum((Enum[])SimplePredicate.Operator.values());
    }

    public static SimpleSetPredicate.BooleanOperator getRandomSimpleSetPredicateOperator() {
        return (SimpleSetPredicate.BooleanOperator)PMMLModelTestUtils.getRandomEnum((Enum[])SimpleSetPredicate.BooleanOperator.values());
    }

    public static MiningField.UsageType getRandomUsageType() {
        return (MiningField.UsageType)PMMLModelTestUtils.getRandomEnum((Enum[])MiningField.UsageType.values());
    }

    public static List<ScoreDistribution> getRandomPMMLScoreDistributions(boolean withProbability) {
        List<Double> probabilities = withProbability ? Arrays.asList(0.1, 0.3, 0.6) : Arrays.asList(null, null, null);
        return IntStream.range(0, 3).mapToObj(i -> PMMLModelTestUtils.getRandomPMMLScoreDistribution((Double)probabilities.get(i))).collect(Collectors.toList());
    }

    public static ScoreDistribution getRandomPMMLScoreDistribution(Double probability) {
        Random random = new Random();
        ComplexScoreDistribution toReturn = new ComplexScoreDistribution();
        toReturn.setValue((Object)RandomStringUtils.random((int)6, (boolean)true, (boolean)false));
        toReturn.setRecordCount((Number)random.nextInt(100));
        toReturn.setConfidence((Number)((double)random.nextInt(1) / 100.0));
        toReturn.setProbability((Number)probability);
        return toReturn;
    }

    public static List<String> getStringObjects(Array.Type arrayType, int size) {
        return IntStream.range(0, size).mapToObj(index -> {
            switch (arrayType) {
                case INT: {
                    return String.valueOf(new Random().nextInt(40));
                }
                case REAL: {
                    return String.valueOf(new Random().nextDouble());
                }
                case STRING: {
                    return RandomStringUtils.random((int)6, (boolean)true, (boolean)false);
                }
            }
            return null;
        }).collect(Collectors.toList());
    }

    public static CompoundPredicate getRandomCompoundPredicate(List<Field<?>> fields) {
        CompoundPredicate toReturn = new CompoundPredicate();
        toReturn.setBooleanOperator(PMMLModelTestUtils.getRandomCompoundPredicateAndOrOperator(new Random().nextInt(10)));
        IntStream.range(0, fields.size() - 1).forEach(i -> toReturn.addPredicates(new Predicate[]{PMMLModelTestUtils.getRandomSimplePredicate((DataField)fields.get(i))}));
        toReturn.addPredicates(new Predicate[]{PMMLModelTestUtils.getRandomSimpleSetPredicate((DataField)fields.get(fields.size() - 1))});
        return toReturn;
    }

    public static CompoundPredicate getRandomCompoundPredicate() {
        CompoundPredicate toReturn = new CompoundPredicate();
        toReturn.setBooleanOperator(PMMLModelTestUtils.getRandomCompoundPredicateAndOrOperator(new Random().nextInt(10)));
        IntStream.range(0, 3).forEach(i -> toReturn.addPredicates(new Predicate[]{PMMLModelTestUtils.getRandomSimplePredicate()}));
        toReturn.addPredicates(new Predicate[]{PMMLModelTestUtils.getRandomSimpleSetPredicate()});
        return toReturn;
    }

    public static SimplePredicate getRandomSimplePredicate(DataField dataField) {
        SimplePredicate toReturn = PMMLModelTestUtils.getRandomSimplePredicate();
        toReturn.setField(dataField.getName());
        toReturn.setValue(PMMLModelTestUtils.getRandomObject(dataField.getDataType()));
        return toReturn;
    }

    public static SimplePredicate getRandomSimplePredicate() {
        String fieldName = RandomStringUtils.random((int)6, (boolean)true, (boolean)false);
        SimplePredicate toReturn = new SimplePredicate();
        toReturn.setField(fieldName);
        toReturn.setOperator(PMMLModelTestUtils.getRandomSimplePredicateOperator());
        toReturn.setValue(PMMLModelTestUtils.getRandomObject(PMMLModelTestUtils.getRandomDataType()));
        return toReturn;
    }

    public static SimpleSetPredicate getRandomSimpleSetPredicate(DataField dataField) {
        SimpleSetPredicate toReturn = PMMLModelTestUtils.getRandomSimpleSetPredicate();
        toReturn.setField(dataField.getName());
        toReturn.setBooleanOperator(PMMLModelTestUtils.getRandomSimpleSetPredicateOperator());
        Array.Type arrayType = PMMLModelTestUtils.getArrayType(dataField.getDataType());
        List<String> values = PMMLModelTestUtils.getStringObjects(arrayType, 3);
        Array array = PMMLModelTestUtils.getArray(arrayType, values);
        toReturn.setArray(array);
        return toReturn;
    }

    public static SimpleSetPredicate getRandomSimpleSetPredicate() {
        String fieldName = RandomStringUtils.random((int)6, (boolean)true, (boolean)false);
        SimpleSetPredicate toReturn = new SimpleSetPredicate();
        toReturn.setField(fieldName);
        toReturn.setBooleanOperator(PMMLModelTestUtils.getRandomSimpleSetPredicateOperator());
        Array.Type arrayType = PMMLModelTestUtils.getRandomArrayType();
        List<String> values = PMMLModelTestUtils.getStringObjects(arrayType, 3);
        Array array = PMMLModelTestUtils.getArray(arrayType, values);
        toReturn.setArray(array);
        return toReturn;
    }

    public static <T extends Named, E extends Enum<E>> List<E> getEnumList(T[] source, Class<E> enumClass) {
        return Arrays.stream(source).map(namedEnum -> Enum.valueOf(enumClass, namedEnum.toString())).collect(Collectors.toList());
    }

    public static <T extends Enum<?>> T getRandomEnum(T[] source) {
        Random random = new Random();
        return source[random.nextInt(source.length)];
    }

    private static List<SimplePredicate> getRandomSimplePredicates(List<SimplePredicate> simplePredicates) {
        int firstIndex = new Random().nextInt(simplePredicates.size());
        int secondIndex = -1;
        while (secondIndex == -1 || secondIndex == firstIndex) {
            secondIndex = new Random().nextInt(simplePredicates.size());
        }
        return Arrays.asList(simplePredicates.get(firstIndex), simplePredicates.get(secondIndex));
    }

    private static CompoundPredicate.BooleanOperator getRandomCompoundPredicateAndOrOperator(int counter) {
        return counter % 2 == 0 ? CompoundPredicate.BooleanOperator.AND : CompoundPredicate.BooleanOperator.OR;
    }
}

