/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.api.enums.builtinfunctions;

import java.util.Arrays;
import org.kie.pmml.api.enums.BUILTIN_FUNCTIONS;
import org.kie.pmml.api.exceptions.KieEnumException;
import org.kie.pmml.api.exceptions.KiePMMLException;

public enum MathematicalFunctions {
    EXPM1("expm1"),
    HYPOT("hypot"),
    LN1P("ln1p"),
    RINT("rint"),
    SIN("sin"),
    ASIN("asin"),
    SINH("sinh"),
    COS("cos"),
    ACOS("acos"),
    COSH("cosh"),
    TAN("tan"),
    ATAN("atan"),
    TANH("tanh");

    private final String name;

    private MathematicalFunctions(String name) {
        this.name = name;
    }

    public static boolean isMathematicalFunctions(String name) {
        return Arrays.stream(MathematicalFunctions.values()).anyMatch(value -> name.equals(value.name));
    }

    public static MathematicalFunctions byName(String name) {
        return Arrays.stream(MathematicalFunctions.values()).filter(value -> name.equals(value.name)).findFirst().orElseThrow(() -> new KieEnumException("Failed to find MathematicalFunctions with name: " + name));
    }

    public String getName() {
        return this.name;
    }

    public Object getValue(Object[] inputData) {
        switch (this) {
            case EXPM1: {
                return this.expm1(inputData);
            }
            case HYPOT: {
                return this.hypot(inputData);
            }
            case LN1P: {
                return this.ln1p(inputData);
            }
            case RINT: {
                return this.rint(inputData);
            }
            case SIN: {
                return this.sin(inputData);
            }
            case ASIN: {
                return this.asin(inputData);
            }
            case SINH: {
                return this.sinh(inputData);
            }
            case COS: {
                return this.cos(inputData);
            }
            case ACOS: {
                return this.acos(inputData);
            }
            case COSH: {
                return this.cosh(inputData);
            }
            case TAN: {
                return this.tan(inputData);
            }
            case ATAN: {
                return this.atan(inputData);
            }
            case TANH: {
                return this.tanh(inputData);
            }
        }
        throw new KiePMMLException("Unmanaged MathematicalFunctions " + this);
    }

    private double expm1(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkNumbers(inputData, 1);
        double x = ((Number)inputData[0]).doubleValue();
        return Math.expm1(x);
    }

    private double hypot(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkNumbers(inputData, 2);
        double x = ((Number)inputData[0]).doubleValue();
        double y = ((Number)inputData[1]).doubleValue();
        return Math.hypot(x, y);
    }

    private double ln1p(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkNumbers(inputData, 1);
        double x = ((Number)inputData[0]).doubleValue();
        return Math.log1p(x);
    }

    private double rint(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkNumbers(inputData, 1);
        double x = ((Number)inputData[0]).doubleValue();
        return Math.rint(x);
    }

    private double sin(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkNumbers(inputData, 1);
        double x = ((Number)inputData[0]).doubleValue();
        return Math.sin(x);
    }

    private double asin(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkNumbers(inputData, 1);
        double x = ((Number)inputData[0]).doubleValue();
        return Math.asin(x);
    }

    private double sinh(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkNumbers(inputData, 1);
        double x = ((Number)inputData[0]).doubleValue();
        return Math.sinh(x);
    }

    private double cos(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkNumbers(inputData, 1);
        double x = ((Number)inputData[0]).doubleValue();
        return Math.cos(x);
    }

    private double acos(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkNumbers(inputData, 1);
        double x = ((Number)inputData[0]).doubleValue();
        return Math.acos(x);
    }

    private double cosh(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkNumbers(inputData, 1);
        double x = ((Number)inputData[0]).doubleValue();
        return Math.cosh(x);
    }

    private double tan(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkNumbers(inputData, 1);
        double x = ((Number)inputData[0]).doubleValue();
        return Math.tan(x);
    }

    private double atan(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkNumbers(inputData, 1);
        double x = ((Number)inputData[0]).doubleValue();
        return Math.atan(x);
    }

    private double tanh(Object[] inputData) {
        BUILTIN_FUNCTIONS.checkNumbers(inputData, 1);
        double x = ((Number)inputData[0]).doubleValue();
        return Math.tanh(x);
    }
}

