/*
 * Decompiled with CFR 0.152.
 */
package org.kie.perf.suite;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import org.kie.perf.Executor;
import org.kie.perf.SharedMetricRegistry;
import org.kie.perf.TestConfig;
import org.kie.perf.annotation.KPKConstraint;
import org.kie.perf.annotation.KPKLimit;
import org.kie.perf.metrics.CPUUsageHistogramSet;
import org.kie.perf.run.IRunType;
import org.kie.perf.scenario.IPerfTest;
import org.kie.perf.suite.ITestSuite;
import org.kie.perf.suite.LoadSuite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentLoadSuite
implements ITestSuite {
    protected static final Logger log = LoggerFactory.getLogger(LoadSuite.class);
    protected int iterations;
    protected IRunType run;

    public ConcurrentLoadSuite() {
        TestConfig tc = TestConfig.getInstance();
        this.iterations = tc.getIterations();
        this.run = tc.getRunType().newInstance();
    }

    @Override
    public void start() throws Exception {
        TestConfig tc = TestConfig.getInstance();
        Executor exec = Executor.getInstance();
        Set<Class<? extends IPerfTest>> scenarios = exec.getScenarios(tc.getTestPackage());
        if (scenarios.size() == 1) {
            IPerfTest scenario = scenarios.iterator().next().newInstance();
            exec.initMetrics(scenario);
            scenario.init();
            if (tc.isWarmUp()) {
                exec.performWarmUp(scenario);
            }
            CPUUsageHistogramSet cpuusage = null;
            boolean cpuusageEnabled = tc.getMeasure().contains((Object)TestConfig.Measure.CPUUSAGE);
            if (cpuusageEnabled) {
                cpuusage = CPUUsageHistogramSet.getInstance(scenario.getClass());
                cpuusage.start();
            }
            this.startScenario(scenario.getClass());
            if (cpuusageEnabled) {
                cpuusage.stop();
            }
            exec.getReporter().report();
        } else {
            for (Class<? extends IPerfTest> c : scenarios) {
                KPKConstraint constraint = exec.checkScenarioConstraints(c);
                if (constraint != null) {
                    log.info("Scenario '" + tc.getScenario() + "' skipped due to constraints " + Arrays.toString(constraint.value()));
                    continue;
                }
                exec.forkScenario(c.getSimpleName());
            }
        }
    }

    private void startScenario(Class<? extends IPerfTest> scenario) {
        ArrayList<ThreadScenario> threadsList = new ArrayList<ThreadScenario>();
        KPKLimit limit = scenario.getAnnotation(KPKLimit.class);
        int max = limit != null ? limit.value() : Integer.MAX_VALUE;
        TestConfig tc = TestConfig.getInstance();
        Timer.Context contextDuration = null;
        if (tc.getRunType() != TestConfig.RunType.DURATION) {
            Timer duration = SharedMetricRegistry.getInstance().timer(MetricRegistry.name(scenario, (String[])new String[]{"scenario.total.duration"}));
            contextDuration = duration.time();
        }
        ArrayList<IPerfTest> tests = new ArrayList<IPerfTest>();
        int threads = tc.getThreads();
        for (int i = 0; i < threads; ++i) {
            try {
                IPerfTest iPerfTest = scenario.newInstance();
                iPerfTest.init();
                iPerfTest.initMetrics();
                tests.add(iPerfTest);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (IPerfTest iPerfTest : tests) {
            ThreadScenario t = new ThreadScenario(iPerfTest, max);
            threadsList.add(t);
        }
        for (Thread thread : threadsList) {
            thread.start();
        }
        for (Thread thread : threadsList) {
            try {
                if (!thread.isAlive()) continue;
                thread.join();
            }
            catch (Exception exception) {}
        }
        if (contextDuration != null) {
            contextDuration.stop();
        }
        for (IPerfTest iPerfTest : tests) {
            iPerfTest.close();
        }
        threadsList.clear();
    }

    private static class ThreadScenario
    extends Thread {
        private IPerfTest scenario;
        private int max;

        public ThreadScenario(IPerfTest scenario, int max) {
            this.scenario = scenario;
            this.max = max;
        }

        @Override
        public void run() {
            Timer duration = SharedMetricRegistry.getInstance().timer(MetricRegistry.name(this.scenario.getClass(), (String[])new String[]{"scenario.single.duration"}));
            IRunType run = TestConfig.getInstance().getRunType().newInstance();
            run.start(this.max);
            while (!run.isEnd()) {
                Timer.Context context = duration.time();
                this.scenario.execute();
                context.stop();
            }
        }
    }
}

