/*
 * Decompiled with CFR 0.152.
 */
package org.kie.perf.suite;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.ArrayList;
import org.kie.perf.SharedMetricRegistry;
import org.kie.perf.TestConfig;
import org.kie.perf.annotation.KPKLimit;
import org.kie.perf.run.IRunType;
import org.kie.perf.scenario.IPerfTest;
import org.kie.perf.suite.ITestSuite;

public class ConcurrentLoadSuite
implements ITestSuite {
    @Override
    public String getTestPackage() {
        return "org.kie.perf.scenario.load";
    }

    @Override
    public void initScenario(IPerfTest scenario) throws Exception {
        scenario.init();
    }

    @Override
    public void startScenario(IPerfTest scenario) {
        ArrayList<ThreadScenario> threadsList = new ArrayList<ThreadScenario>();
        KPKLimit limit = scenario.getClass().getAnnotation(KPKLimit.class);
        int max = limit != null ? limit.value() : Integer.MAX_VALUE;
        TestConfig tc = TestConfig.getInstance();
        Timer.Context contextDuration = null;
        if (tc.getRunType() != TestConfig.RunType.DURATION) {
            Timer duration = SharedMetricRegistry.getInstance().timer(MetricRegistry.name(scenario.getClass(), (String[])new String[]{"scenario.total.duration"}));
            contextDuration = duration.time();
        }
        ArrayList<IPerfTest> tests = new ArrayList<IPerfTest>();
        int threads = tc.getThreads();
        for (int i = 0; i < threads; ++i) {
            try {
                IPerfTest iPerfTest = (IPerfTest)scenario.getClass().newInstance();
                iPerfTest.init();
                iPerfTest.initMetrics();
                tests.add(iPerfTest);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (IPerfTest iPerfTest : tests) {
            ThreadScenario t = new ThreadScenario(iPerfTest, max);
            threadsList.add(t);
        }
        for (Thread thread : threadsList) {
            thread.start();
        }
        for (Thread thread : threadsList) {
            try {
                if (!thread.isAlive()) continue;
                thread.join();
            }
            catch (Exception exception) {}
        }
        if (contextDuration != null) {
            contextDuration.stop();
        }
        for (IPerfTest iPerfTest : tests) {
            iPerfTest.close();
        }
        scenario.close();
        threadsList.clear();
    }

    private static class ThreadScenario
    extends Thread {
        private IPerfTest scenario;
        private int max;

        public ThreadScenario(IPerfTest scenario, int max) {
            this.scenario = scenario;
            this.max = max;
        }

        @Override
        public void run() {
            Timer duration = SharedMetricRegistry.getInstance().timer(MetricRegistry.name(this.scenario.getClass(), (String[])new String[]{"scenario.single.duration"}));
            IRunType run = TestConfig.getInstance().getRunType().newInstance();
            run.start(this.max);
            while (!run.isEnd()) {
                Timer.Context context = duration.time();
                this.scenario.execute();
                context.stop();
            }
        }
    }
}

