/*
 * Decompiled with CFR 0.152.
 */
package org.kie.memorycompiler.resources;

import java.io.File;
import java.io.Serializable;
import java.util.Objects;

public class KiePath
implements Serializable {
    private static final boolean IS_WINDOWS_SEPARATOR = File.separatorChar == '\\';
    public static final KiePath ROOT_PATH = new KiePath("");
    private String path;

    public KiePath() {
    }

    private KiePath(String path) {
        this.path = path;
    }

    public static KiePath of(String s) {
        return KiePath.of(s, IS_WINDOWS_SEPARATOR);
    }

    static KiePath of(String s, boolean isWindowsSeparator) {
        String normalized = KiePath.normalizePath(s, isWindowsSeparator);
        return normalized.isEmpty() ? ROOT_PATH : new KiePath(normalized);
    }

    private static String normalizePath(String s, boolean isWindowsSeparator) {
        if (s == null) {
            throw new NullPointerException("A path cannot be null");
        }
        return KiePath.trimTrailingSeparator(isWindowsSeparator ? s.replace('\\', '/') : s);
    }

    public KiePath getParent() {
        int lastSlash = this.path.lastIndexOf(47);
        return lastSlash >= 0 ? new KiePath(this.path.substring(0, lastSlash)) : ROOT_PATH;
    }

    public boolean isEmpty() {
        return this.path.isEmpty();
    }

    public KiePath resolve(KiePath kiePath) {
        return this.isEmpty() ? kiePath : new KiePath(this.path + "/" + kiePath.asString());
    }

    public KiePath resolve(String name) {
        return this.resolve(KiePath.of(name));
    }

    public String getFileName() {
        int lastSlash = this.path.lastIndexOf(47);
        return lastSlash >= 0 ? this.path.substring(lastSlash + 1) : this.path;
    }

    public String asString() {
        return this.path;
    }

    public String asClassName() {
        return this.path.substring(0, this.path.length() - ".class".length()).replace('/', '.');
    }

    public String toString() {
        return "KiePath{path='" + this.path + '\'' + '}';
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KiePath)) {
            return false;
        }
        KiePath kiePath = (KiePath)o;
        return Objects.equals(this.path, kiePath.path);
    }

    public boolean endsWith(String s) {
        return this.path.endsWith(s);
    }

    public boolean startsWith(String s) {
        return this.path.startsWith(s);
    }

    public KiePath substring(int beginIndex) {
        return KiePath.of(this.path.substring(beginIndex));
    }

    public KiePath substring(int beginIndex, int endIndex) {
        return KiePath.of(this.path.substring(beginIndex, endIndex));
    }

    public static String trimTrailingSeparator(String p) {
        return !p.isEmpty() && p.charAt(p.length() - 1) == '/' ? p.substring(0, p.length() - 1) : p;
    }
}

