/*
 * Decompiled with CFR 0.152.
 */
package org.kie.camel;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.impl.DefaultProducer;
import org.kie.api.KieServices;
import org.kie.api.command.Command;
import org.kie.camel.KieCamelUtils;
import org.kie.camel.KieEndpoint;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.client.DMNServicesClient;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.KieServicesFactory;
import org.kie.server.client.ProcessServicesClient;
import org.kie.server.client.RuleServicesClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieProducer
extends DefaultProducer {
    private static final transient Logger log = LoggerFactory.getLogger(KieProducer.class);
    private static final String DEFAULT_CLIENT = "KieServices";
    private final KieEndpoint endpoint;
    private final KieServicesClient client;
    private final Map<String, InternalProducer> producers = new HashMap<String, InternalProducer>();

    public KieProducer(KieEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.client = KieServicesFactory.newKieServicesClient((KieServicesConfiguration)endpoint.getKieServicesConf());
    }

    public void process(Exchange exchange) throws Exception {
        this.getProducer(exchange).execute(exchange);
    }

    private InternalProducer getProducer(Exchange exchange) {
        String clientName = this.endpoint.getClient() != null ? this.endpoint.getClient() : (String)exchange.getIn().getHeader("CamelKieClient", (Object)DEFAULT_CLIENT, String.class);
        return this.producers.computeIfAbsent(clientName, name -> {
            String producerName = KieProducer.class.getName() + "$" + KieCamelUtils.ucFirst(name) + "Producer";
            try {
                Class<?> producerClass = Class.forName(producerName);
                return (InternalProducer)producerClass.getConstructor(KieServicesClient.class, String.class, KieEndpoint.class).newInstance(new Object[]{this.client, clientName, this.endpoint});
            }
            catch (Exception e) {
                log.error("Unknown client name: " + clientName);
                return new DummyProducer();
            }
        });
    }

    static class DmnProducer
    extends AbstractReflectiveProducer<DMNServicesClient> {
        public DmnProducer(KieServicesClient client, String clientName, KieEndpoint endpoint) {
            super(client.getServicesClient(DMNServicesClient.class), clientName, endpoint);
        }
    }

    static class ProcessProducer
    extends AbstractReflectiveProducer<ProcessServicesClient> {
        public ProcessProducer(KieServicesClient client, String clientName, KieEndpoint endpoint) {
            super(client.getServicesClient(ProcessServicesClient.class), clientName, endpoint);
        }
    }

    static class RuleProducer
    extends AbstractReflectiveProducer<RuleServicesClient> {
        public RuleProducer(KieServicesClient client, String clientName, KieEndpoint endpoint) {
            super(client.getServicesClient(RuleServicesClient.class), clientName, endpoint);
        }

        static enum Operations implements Operation<RuleServicesClient>
        {
            fireAllRules{

                @Override
                public Object execute(RuleServicesClient client, Exchange exchange) {
                    String containerId = (String)exchange.getIn().getHeader("containerId", String.class);
                    Command fireCommand = KieServices.get().getCommands().newFireAllRules();
                    return client.executeCommandsWithResults(containerId, fireCommand);
                }
            };

        }
    }

    static class KieServicesProducer
    extends AbstractReflectiveProducer<KieServicesClient> {
        public KieServicesProducer(KieServicesClient client, String clientName, KieEndpoint endpoint) {
            super(client, clientName, endpoint);
        }

        static enum Operations implements Operation<KieServicesClient>
        {
            myCustomOperation{

                @Override
                public Object execute(KieServicesClient client, Exchange exchange) {
                    return client.getServerInfo();
                }
            };

        }
    }

    static class DummyProducer
    implements InternalProducer {
        DummyProducer() {
        }

        @Override
        public void execute(Exchange exchange) {
        }
    }

    static interface Operation<C> {
        public Object execute(C var1, Exchange var2);
    }

    static abstract class AbstractReflectiveProducer<C>
    extends AbstractInternalProducer<C> {
        private final Map<String, Collection<Method>> methodsMap;
        private final String clientName;
        private final KieEndpoint endpoint;

        protected AbstractReflectiveProducer(C client, String clientName, KieEndpoint endpoint) {
            super(client);
            this.clientName = clientName;
            this.endpoint = endpoint;
            this.methodsMap = this.indexClientMethod((Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0]);
        }

        @Override
        public final void execute(Exchange exchange) {
            String operationName = this.endpoint.getOperation() != null ? this.endpoint.getOperation() : (String)exchange.getIn().getHeader("CamelKieOperation", String.class);
            Object response = this.getOperation(operationName).map(op -> op.execute(this.client, exchange)).orElseGet(() -> this.executeViaReflection(operationName, exchange));
            this.writeResponse(exchange, response);
        }

        private void writeResponse(Exchange exchange, Object response) {
            if (response instanceof ServiceResponse) {
                ServiceResponse serviceResponse = (ServiceResponse)response;
                Message message = KieCamelUtils.getResultMessage(exchange);
                message.setBody(serviceResponse.getResult());
                message.setHeader("CamelKieResponseType", (Object)serviceResponse.getType());
                message.setHeader("CamelKieResponseMessage", (Object)serviceResponse.getMsg());
            } else {
                KieCamelUtils.getResultMessage(exchange).setBody(response);
            }
        }

        private Object executeViaReflection(String operationName, Exchange exchange) {
            Collection<Method> methods = this.methodsMap.get(operationName);
            if (methods == null) {
                log.error("Unknown operation name: " + operationName);
                return null;
            }
            String bodyParam = this.endpoint.getConfiguration().getBodyParam(this.clientName, operationName);
            Method method = methods.stream().filter(m -> this.invokable(exchange, (Method)m, bodyParam)).findFirst().orElseGet(() -> {
                log.error("Unknown operation name: " + operationName);
                return null;
            });
            return method != null ? this.invoke(exchange, method, bodyParam) : null;
        }

        private boolean invokable(Exchange exchange, Method method, String bodyParam) {
            Set headers = exchange.getIn().getHeaders().keySet();
            return Stream.of(method.getParameters()).allMatch(p -> p.getName().equals(bodyParam) || headers.contains(KieCamelUtils.asCamelKieName(p.getName())));
        }

        private Object invoke(Exchange exchange, Method method, String bodyParam) {
            try {
                Object[] args = Stream.of(method.getParameters()).map(p -> p.getName().equals(bodyParam) ? exchange.getIn().getBody(p.getType()) : exchange.getIn().getHeader(KieCamelUtils.asCamelKieName(p.getName()), p.getType())).toArray();
                return method.invoke(this.client, args);
            }
            catch (Exception e) {
                log.error("Error executed operation: " + method.getName() + " caused by: " + e.getMessage(), (Throwable)e);
                return null;
            }
        }

        private Map<String, Collection<Method>> indexClientMethod(Class<?> cls) {
            return Stream.of(cls.getMethods()).collect(Collectors.groupingBy(Method::getName, Collector.of(() -> new TreeSet((m1, m2) -> m2.getParameterCount() - m1.getParameterCount()), Collection::add, (left, right) -> {
                left.addAll(right);
                return left;
            }, new Collector.Characteristics[0])));
        }
    }

    static abstract class AbstractInternalProducer<C>
    implements InternalProducer {
        protected final C client;
        private final Optional<Method> operationLookupMethod;

        protected AbstractInternalProducer(C client) {
            this.client = client;
            this.operationLookupMethod = this.getLookupMethod();
        }

        protected Optional<Operation<C>> getOperation(String operationName) {
            return this.operationLookupMethod.flatMap(m -> {
                try {
                    return Optional.of((Operation)m.invoke(null, operationName));
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    return Optional.empty();
                }
            });
        }

        private Optional<Method> getLookupMethod() {
            try {
                Class<?> enumClass = Class.forName(this.getClass().getName() + "$Operations");
                return Optional.of(enumClass.getMethod("valueOf", String.class));
            }
            catch (Exception e) {
                return Optional.empty();
            }
        }
    }

    static interface InternalProducer {
        public void execute(Exchange var1);
    }
}

