/*
 * Decompiled with CFR 0.152.
 */
package org.kie.camel.embedded.component;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.impl.DefaultConsumer;
import org.drools.core.command.runtime.RegisterChannelCommand;
import org.drools.core.command.runtime.UnregisterChannelCommand;
import org.kie.api.command.Command;
import org.kie.api.runtime.Channel;
import org.kie.api.runtime.CommandExecutor;
import org.kie.camel.embedded.component.KieEmbeddedEndpoint;

public class KieConsumer
extends DefaultConsumer {
    private KieEmbeddedEndpoint ke;
    private CommandExecutor krt;
    private String channelId;

    public KieConsumer(Endpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.ke = (KieEmbeddedEndpoint)endpoint;
        this.krt = this.ke.getExecutor();
        this.channelId = this.ke.getChannel();
    }

    protected void doStop() throws Exception {
        this.krt.execute((Command)new UnregisterChannelCommand(this.channelId));
        super.doStop();
    }

    protected void doStart() throws Exception {
        super.doStart();
        KSessionChannel channel = new KSessionChannel();
        this.krt.execute((Command)new RegisterChannelCommand(this.channelId, (Channel)channel));
    }

    class KSessionChannel
    implements Channel {
        KSessionChannel() {
        }

        public void send(Object pojo) {
            Exchange exchange = KieConsumer.this.ke.createExchange(pojo);
            try {
                KieConsumer.this.getProcessor().process(exchange);
            }
            catch (Exception e) {
                KieConsumer.this.handleException(e);
            }
        }
    }
}

