/*
 * Decompiled with CFR 0.152.
 */
package org.kie.camel;

import java.util.Map;
import javax.naming.InitialContext;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.impl.DefaultComponent;
import org.kie.camel.KieConfiguration;
import org.kie.camel.KieEndpoint;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.KieServicesFactory;

public class KieComponent
extends DefaultComponent {
    private KieConfiguration configuration;

    public KieComponent() {
    }

    public KieComponent(CamelContext context) {
        super(context);
    }

    public KieComponent(KieConfiguration configuration) {
        this.configuration = configuration;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        KieConfiguration kieConfiguration = this.getConfiguration().copy();
        kieConfiguration.configure(remaining);
        this.setProperties(kieConfiguration, parameters);
        KieServicesConfiguration kieServicesConf = remaining.startsWith("jms") ? KieServicesFactory.newJMSConfiguration((InitialContext)null, null, null) : KieServicesFactory.newRestConfiguration((String)remaining, null, null);
        kieServicesConf.setUserName(kieConfiguration.getUsername());
        kieServicesConf.setPassword(kieConfiguration.getPassword());
        if (kieConfiguration.getKieServicesConfigurationCustomizer() != null) {
            kieServicesConf = (KieServicesConfiguration)kieConfiguration.getKieServicesConfigurationCustomizer().apply(kieServicesConf);
        }
        return new KieEndpoint(uri, this, kieServicesConf, this.configuration);
    }

    public KieConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new KieConfiguration();
        }
        return this.configuration;
    }

    public void setConfiguration(KieConfiguration configuration) {
        this.configuration = configuration;
    }
}

