/*
 * Decompiled with CFR 0.152.
 */
package org.kie.hacep.core;

import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.time.SessionClock;
import org.kie.api.time.SessionPseudoClock;
import org.kie.hacep.consumer.FactHandlesManager;
import org.kie.hacep.core.infra.SnapshotInfos;

public class KieSessionContext {
    private KieSession kieSession;
    private SessionPseudoClock clock;
    private FactHandlesManager fhManager;
    private KieContainer kieContainer;

    public KieSession getKieSession() {
        return this.kieSession;
    }

    public KieContainer getKieContainer() {
        return this.kieContainer;
    }

    public Optional<String> getKjarGAVUsed() {
        ReleaseId releaseId = this.kieContainer.getReleaseId();
        String gav = null;
        if (releaseId != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(releaseId.getGroupId()).append(":").append(releaseId.getArtifactId()).append(":").append(releaseId.getVersion());
            gav = sb.toString();
        }
        return Optional.ofNullable(gav);
    }

    public void initFromSnapshot(SnapshotInfos infos) {
        this.setKieSessionAndKieContainer(infos.getKieSession(), infos.getKieContainer());
        this.fhManager = infos.getFhManager();
    }

    public void init(KieContainer kieContainer, KieSession newKiesession) {
        this.setKieSessionAndKieContainer(newKiesession, kieContainer);
        this.fhManager = new FactHandlesManager(newKiesession);
    }

    private void setKieSessionAndKieContainer(KieSession kieSession, KieContainer kieContainer) {
        this.kieSession = kieSession;
        this.kieContainer = kieContainer;
        SessionClock sessionClock = kieSession.getSessionClock();
        if (sessionClock instanceof SessionPseudoClock) {
            this.clock = (SessionPseudoClock)sessionClock;
        }
    }

    public FactHandlesManager getFhManager() {
        return this.fhManager;
    }

    public void setClockAt(long time) {
        if (this.clock == null) {
            throw new IllegalStateException("Drools HACEP is not running with a pseudo-clock");
        }
        this.clock.advanceTime(time - this.clock.getCurrentTime(), TimeUnit.MILLISECONDS);
    }
}

