/*
 * Decompiled with CFR 0.152.
 */
package org.kie.hacep;

import java.time.Duration;
import java.util.Optional;
import org.kie.hacep.Config;
import org.kie.hacep.PollUnit;
import org.kie.hacep.util.PrinterLogImpl;

public final class EnvConfig {
    private String namespace;
    private String eventsTopicName;
    private String controlTopicName;
    private String snapshotTopicName;
    private String kieSessionInfosTopicName;
    private String printerType;
    private int iterationBetweenSnapshot = 10;
    private int pollTimeout = 1000;
    private int pollSnapshotTimeout = 1;
    private int maxSnapshotRequestAttempts = 30;
    private boolean skipOnDemanSnapshot;
    private long maxSnapshotAge;
    private boolean test;
    private boolean local;
    private PollUnit pollUnit;
    private PollUnit pollUnitSnapshot;
    private Duration pollDuration;
    private Duration pollSnapshotDuration;
    private boolean updatableKJar;
    private String kJarGAV;
    public static final String SECONDS = "sec";
    public static final String MILLISEC = "millisec";

    private EnvConfig() {
    }

    public static EnvConfig getDefaultEnvConfig() {
        return EnvConfig.anEnvConfig().withNamespace(Optional.ofNullable(System.getenv("namespace")).orElse("default")).withControlTopicName(Optional.ofNullable(System.getenv("control")).orElse("control")).withEventsTopicName(Optional.ofNullable(System.getenv("events")).orElse("events")).withSnapshotTopicName(Optional.ofNullable(System.getenv("snapshot")).orElse("snapshot")).withKieSessionInfosTopicName(Optional.ofNullable(System.getenv("kiesessioninfos")).orElse("kiesessioninfos")).withPrinterType(Optional.ofNullable(System.getenv("printer.type")).orElse(PrinterLogImpl.class.getName())).withPollTimeout(Optional.ofNullable(System.getenv("poll.timeout")).orElse(String.valueOf(1000))).withPollTimeUnit(Optional.ofNullable(System.getenv("poll.timeout.unit")).orElse(MILLISEC)).withPollSnapshotTimeout(Optional.ofNullable(System.getenv("poll.timeout.snapshot")).orElse(String.valueOf(1))).withPollSnapshotTimeUnit(Optional.ofNullable(System.getenv("poll.timeout.unit.snapshot")).orElse(SECONDS)).skipOnDemandSnapshot(Optional.ofNullable(System.getenv("skip.ondemandsnapshoot")).orElse(Boolean.FALSE.toString())).withIterationBetweenSnapshot(Optional.ofNullable(System.getenv("iteration.between.snapshot")).orElse(String.valueOf(10))).withMaxSnapshotAgeSeconds(Optional.ofNullable(System.getenv("max.snapshot.age")).orElse("600")).withMaxSnapshotRequestAttempts(Optional.ofNullable(System.getenv("max.snapshot.request.attempts")).orElse("30")).withUpdatableKJar(Optional.ofNullable(System.getenv("UPDATABLEKJAR")).orElse(Boolean.FALSE.toString())).withKJarGAV(Optional.ofNullable(System.getenv("KJARGAV")).orElse(null)).underTest(Optional.ofNullable(System.getenv("undertest")).orElse(Config.TEST));
    }

    public static EnvConfig anEnvConfig() {
        return new EnvConfig();
    }

    public EnvConfig withNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public EnvConfig withEventsTopicName(String eventsTopicName) {
        this.eventsTopicName = eventsTopicName;
        return this;
    }

    public EnvConfig withControlTopicName(String controlTopicName) {
        this.controlTopicName = controlTopicName;
        return this;
    }

    public EnvConfig withSnapshotTopicName(String snapshotTopicName) {
        this.snapshotTopicName = snapshotTopicName;
        return this;
    }

    public EnvConfig withKieSessionInfosTopicName(String kieSessionInfosTopicName) {
        this.kieSessionInfosTopicName = kieSessionInfosTopicName;
        return this;
    }

    public EnvConfig withPrinterType(String printerType) {
        this.printerType = printerType;
        return this;
    }

    public EnvConfig withPollTimeout(String pollTimeout) {
        this.pollTimeout = Integer.valueOf(pollTimeout);
        return this;
    }

    public EnvConfig withPollSnapshotTimeout(String pollSnapshotTimeout) {
        this.pollSnapshotTimeout = Integer.valueOf(pollSnapshotTimeout);
        return this;
    }

    public EnvConfig withIterationBetweenSnapshot(String iterationBetweenSnapshot) {
        this.iterationBetweenSnapshot = Integer.valueOf(iterationBetweenSnapshot);
        return this;
    }

    public EnvConfig underTest(String underTest) {
        return this.underTest(Boolean.valueOf(underTest));
    }

    public EnvConfig underTest(boolean underTest) {
        this.test = underTest;
        return this;
    }

    public EnvConfig local(boolean local) {
        this.local = local;
        return this;
    }

    public EnvConfig skipOnDemandSnapshot(String skipOnDemandSnapshoot) {
        this.skipOnDemanSnapshot = Boolean.valueOf(skipOnDemandSnapshoot);
        return this;
    }

    public EnvConfig withMaxSnapshotAgeSeconds(String maxSnapshotAge) {
        this.maxSnapshotAge = Long.valueOf(maxSnapshotAge);
        return this;
    }

    public EnvConfig withMaxSnapshotRequestAttempts(String maxSnapshotRequestAttempts) {
        this.maxSnapshotRequestAttempts = Integer.parseInt(maxSnapshotRequestAttempts);
        return this;
    }

    public EnvConfig withPollTimeUnit(String pollTimeUnit) {
        if (pollTimeUnit == null) {
            throw new IllegalArgumentException("No pollTimeUnit provided");
        }
        switch (pollTimeUnit) {
            case "millisec": {
                this.pollUnit = PollUnit.MILLISECOND;
                this.pollDuration = Duration.ofMillis(this.pollTimeout);
                break;
            }
            case "sec": {
                this.pollUnit = PollUnit.SECOND;
                this.pollDuration = Duration.ofSeconds(this.pollTimeout);
                break;
            }
            default: {
                throw new IllegalArgumentException("No pollTimeUnit provided");
            }
        }
        return this;
    }

    public EnvConfig withPollSnapshotTimeUnit(String pollSnapshotTimeUnit) {
        if (pollSnapshotTimeUnit == null) {
            throw new IllegalArgumentException("No pollSnapshotTimeUnit provided");
        }
        switch (pollSnapshotTimeUnit) {
            case "millisec": {
                this.pollUnitSnapshot = PollUnit.MILLISECOND;
                this.pollSnapshotDuration = Duration.ofMillis(this.pollSnapshotTimeout);
                break;
            }
            case "sec": {
                this.pollUnitSnapshot = PollUnit.SECOND;
                this.pollSnapshotDuration = Duration.ofSeconds(this.pollSnapshotTimeout);
                break;
            }
            default: {
                throw new IllegalArgumentException("No pollSnapshotTimeUnit provided");
            }
        }
        return this;
    }

    public EnvConfig withUpdatableKJar(String updatableKJar) {
        this.updatableKJar = Boolean.valueOf(updatableKJar);
        return this;
    }

    public EnvConfig withKJarGAV(String kjarGAV) {
        this.kJarGAV = kjarGAV;
        return this;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getEventsTopicName() {
        return this.eventsTopicName;
    }

    public String getControlTopicName() {
        return this.controlTopicName;
    }

    public String getSnapshotTopicName() {
        return this.snapshotTopicName;
    }

    public String getKieSessionInfosTopicName() {
        return this.kieSessionInfosTopicName;
    }

    public String getPrinterType() {
        return this.printerType;
    }

    public boolean isUnderTest() {
        return this.test;
    }

    public int getPollTimeout() {
        return this.pollTimeout;
    }

    public int getPollSnapshotTimeout() {
        return this.pollSnapshotTimeout;
    }

    public int getIterationBetweenSnapshot() {
        return this.iterationBetweenSnapshot;
    }

    public boolean isSkipOnDemandSnapshot() {
        return this.skipOnDemanSnapshot;
    }

    public long getMaxSnapshotAge() {
        return this.maxSnapshotAge;
    }

    public boolean isLocal() {
        return this.local;
    }

    public int getMaxSnapshotRequestAttempts() {
        return this.maxSnapshotRequestAttempts;
    }

    public PollUnit getPollUnit() {
        return this.pollUnit;
    }

    public PollUnit getPollSnapshotUnit() {
        return this.pollUnitSnapshot;
    }

    public Duration getPollDuration() {
        return this.pollDuration;
    }

    public Duration getPollSnapshotDuration() {
        return this.pollSnapshotDuration;
    }

    public boolean isUpdatableKJar() {
        return this.updatableKJar;
    }

    public String getKJarGAV() {
        return this.kJarGAV;
    }
}

