/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.common.api.io;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Path;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryFile
extends File
implements Serializable {
    private static final long serialVersionUID = 1690003941627937413L;
    private static final Logger logger = LoggerFactory.getLogger(MemoryFile.class);
    private String name;
    private transient Path filePath;
    private final URL url;
    private byte[] content;

    public MemoryFile(Path filePath) throws IOException {
        super(filePath.toString());
        logger.debug("MemoryFile {}", (Object)filePath);
        logger.debug(this.getAbsolutePath());
        this.name = filePath.getFileName().toString();
        this.filePath = filePath;
        this.url = filePath.toUri().toURL();
        this.initContent(this.url);
    }

    public MemoryFile(URL url) throws IOException {
        super(url.getPath());
        logger.debug("MemoryFile {}", (Object)url);
        logger.debug(this.getAbsolutePath());
        this.name = url.getFile();
        if (this.name.contains("/")) {
            this.name = this.name.substring(this.name.lastIndexOf("/") + 1);
        }
        this.url = url;
        this.initContent(this.url);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean exists() {
        return this.url != null;
    }

    private void initContent(URL url) throws IOException {
        logger.debug("initContent {}", (Object)url);
        if (url != null) {
            try (InputStream input = url.openStream();){
                int read;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] bytes = new byte[1024];
                while ((read = input.read(bytes)) != -1) {
                    out.write(bytes, 0, read);
                }
                this.content = out.toByteArray();
                out.flush();
                out.close();
            }
        }
    }

    public byte[] getContent() {
        return this.content;
    }

    @Override
    public Path toPath() {
        try {
            String urlProtocol = this.url.getProtocol().equals("jar") ? "jar:" : "";
            String path = String.format("%s%s", urlProtocol, this.url.getPath());
            return Path.of(path, new String[0]);
        }
        catch (Exception e) {
            return super.toPath();
        }
    }

    @Override
    public boolean canRead() {
        return this.content != null;
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    @Override
    public long length() {
        return this.content != null ? (long)this.content.length : 0L;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MemoryFile that = (MemoryFile)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.filePath, that.filePath) && Objects.equals(this.url, that.url);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.name, this.filePath, this.url);
    }

    @Override
    public String toString() {
        return "MemoryFile{name='" + this.name + "', filePath=" + this.filePath + ", url=" + this.url + "} " + super.toString();
    }
}

