/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.infinispan;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.drools.core.SessionConfiguration;
import org.drools.core.command.SingleSessionCommandService;
import org.drools.core.command.impl.CommandBasedStatefulKnowledgeSession;
import org.drools.core.process.instance.WorkItemManagerFactory;
import org.drools.core.runtime.ChainableRunner;
import org.drools.core.time.TimerService;
import org.drools.persistence.PersistableRunner;
import org.drools.persistence.api.TransactionManagerFactory;
import org.drools.persistence.infinispan.InfinispanJDKTimerService;
import org.drools.persistence.infinispan.InfinispanPersistenceContextManager;
import org.drools.persistence.infinispan.ManualPersistInterceptor;
import org.drools.persistence.infinispan.processinstance.InfinispanWorkItemManagerFactory;
import org.kie.api.KieBase;
import org.kie.api.persistence.jpa.KieStoreServices;
import org.kie.api.runtime.CommandExecutor;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.ExecutableRunner;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class KnowledgeStoreServiceImpl
implements KieStoreServices {
    private Class<? extends CommandExecutor> commandServiceClass;
    private Class<? extends WorkItemManagerFactory> workItemManagerFactoryClass;
    private Properties configProps = new Properties();

    public KnowledgeStoreServiceImpl() {
        this.setDefaultImplementations();
    }

    protected void setDefaultImplementations() {
        this.setCommandServiceClass(PersistableRunner.class);
        this.setProcessInstanceManagerFactoryClass("org.jbpm.persistence.processinstance.InfinispanProcessInstanceManagerFactory");
        this.setWorkItemManagerFactoryClass(InfinispanWorkItemManagerFactory.class);
        this.setProcessSignalManagerFactoryClass("org.jbpm.persistence.processinstance.InfinispanSignalManagerFactory");
        this.setTimerServiceClass(InfinispanJDKTimerService.class);
    }

    public StatefulKnowledgeSession newKieSession(KieBase kbase, KieSessionConfiguration configuration, Environment environment) {
        if (configuration == null) {
            configuration = SessionConfiguration.newInstance();
        }
        if (environment == null) {
            throw new IllegalArgumentException("Environment cannot be null");
        }
        CommandExecutor commandService = this.buildCommandService(kbase, this.mergeConfig(configuration), environment);
        if (commandService instanceof SingleSessionCommandService) {
            ((PersistableRunner)commandService).addInterceptor((ChainableRunner)new ManualPersistInterceptor((SingleSessionCommandService)commandService));
            try {
                Class<?> clazz = Class.forName("org.jbpm.persistence.ManualPersistProcessInterceptor");
                Constructor<?> c = clazz.getConstructor(SingleSessionCommandService.class);
                ChainableRunner interceptor = (ChainableRunner)c.newInstance(commandService);
                ((PersistableRunner)commandService).addInterceptor(interceptor);
            }
            catch (ClassNotFoundException clazz) {
            }
            catch (Exception e) {
                throw new RuntimeException("Something wrong initializing manual process persistor interceptor", e);
            }
        }
        return new CommandBasedStatefulKnowledgeSession((ExecutableRunner)commandService);
    }

    public StatefulKnowledgeSession loadKieSession(int id, KieBase kbase, KieSessionConfiguration configuration, Environment environment) {
        if (configuration == null) {
            configuration = SessionConfiguration.newInstance();
        }
        if (environment == null) {
            throw new IllegalArgumentException("Environment cannot be null");
        }
        CommandExecutor commandService = this.buildCommandService(new Long(id), kbase, this.mergeConfig(configuration), environment);
        if (commandService instanceof SingleSessionCommandService) {
            ((PersistableRunner)commandService).addInterceptor((ChainableRunner)new ManualPersistInterceptor((SingleSessionCommandService)commandService));
            try {
                Class<?> clazz = Class.forName("org.jbpm.persistence.ManualPersistProcessInterceptor");
                Constructor<?> c = clazz.getConstructor(PersistableRunner.class);
                ChainableRunner interceptor = (ChainableRunner)c.newInstance(commandService);
                ((PersistableRunner)commandService).addInterceptor(interceptor);
            }
            catch (ClassNotFoundException clazz) {
            }
            catch (Exception e) {
                throw new RuntimeException("Something wrong initializing manual process persistor interceptor", e);
            }
        }
        return new CommandBasedStatefulKnowledgeSession((ExecutableRunner)commandService);
    }

    public StatefulKnowledgeSession loadKieSession(Long id, KieBase kbase, KieSessionConfiguration configuration, Environment environment) {
        if (configuration == null) {
            configuration = SessionConfiguration.newInstance();
        }
        if (environment == null) {
            throw new IllegalArgumentException("Environment cannot be null");
        }
        CommandExecutor commandService = this.buildCommandService(id, kbase, this.mergeConfig(configuration), environment);
        if (commandService instanceof SingleSessionCommandService) {
            ((PersistableRunner)commandService).addInterceptor((ChainableRunner)new ManualPersistInterceptor((SingleSessionCommandService)commandService));
            try {
                Class<?> clazz = Class.forName("org.jbpm.persistence.ManualPersistProcessInterceptor");
                Constructor<?> c = clazz.getConstructor(SingleSessionCommandService.class);
                ChainableRunner interceptor = (ChainableRunner)c.newInstance(commandService);
                ((PersistableRunner)commandService).addInterceptor(interceptor);
            }
            catch (ClassNotFoundException clazz) {
            }
            catch (Exception e) {
                throw new RuntimeException("Something wrong initializing manual process persistor interceptor", e);
            }
        }
        return new CommandBasedStatefulKnowledgeSession((ExecutableRunner)commandService);
    }

    private CommandExecutor buildCommandService(Long sessionId, KieBase kbase, KieSessionConfiguration conf, Environment env) {
        env = this.mergeEnvironment(env);
        try {
            Class<? extends CommandExecutor> serviceClass = this.getCommandServiceClass();
            Constructor<? extends CommandExecutor> constructor = serviceClass.getConstructor(Long.class, KieBase.class, KieSessionConfiguration.class, Environment.class);
            return constructor.newInstance(sessionId, kbase, conf, env);
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    private Environment mergeEnvironment(Environment env) {
        Object tm;
        if (env == null) {
            env = KnowledgeBaseFactory.newEnvironment();
        }
        if (env.get("org.kie.api.persistence.PersistenceContextManager") == null) {
            try {
                Class<?> clazz = Class.forName("org.jbpm.persistence.InfinispanProcessPersistenceContextManager");
                Constructor<?> c = clazz.getConstructor(Environment.class);
                env.set("org.kie.api.persistence.PersistenceContextManager", c.newInstance(env));
            }
            catch (ClassNotFoundException e) {
                env.set("org.kie.api.persistence.PersistenceContextManager", (Object)new InfinispanPersistenceContextManager(env));
            }
            catch (Exception e) {
                e.printStackTrace();
                env.set("org.kie.api.persistence.PersistenceContextManager", (Object)new InfinispanPersistenceContextManager(env));
            }
        }
        if ((tm = env.get("org.kie.transaction.TransactionManager")) instanceof TransactionManager) {
            Object ut = env.get("org.kie.transaction.Transaction");
            if (ut == null && tm instanceof UserTransaction) {
                env.set("org.kie.transaction.Transaction", tm);
            }
            env.set("org.kie.transaction.TransactionManager", (Object)TransactionManagerFactory.get().newTransactionManager(env));
        }
        return env;
    }

    private CommandExecutor buildCommandService(KieBase kbase, KieSessionConfiguration conf, Environment env) {
        env = this.mergeEnvironment(env);
        Class<? extends CommandExecutor> serviceClass = this.getCommandServiceClass();
        try {
            Constructor<? extends CommandExecutor> constructor = serviceClass.getConstructor(KieBase.class, KieSessionConfiguration.class, Environment.class);
            return constructor.newInstance(kbase, conf, env);
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    private KieSessionConfiguration mergeConfig(KieSessionConfiguration configuration) {
        return ((SessionConfiguration)configuration).addDefaultProperties(this.configProps);
    }

    public long getStatefulKnowledgeSessionId(StatefulKnowledgeSession ksession) {
        if (ksession instanceof CommandBasedStatefulKnowledgeSession) {
            SingleSessionCommandService commandService = (SingleSessionCommandService)((CommandBasedStatefulKnowledgeSession)ksession).getRunner();
            return commandService.getSessionId();
        }
        throw new IllegalArgumentException("StatefulKnowledgeSession must be an a CommandBasedStatefulKnowledgeSession");
    }

    public void setCommandServiceClass(Class<? extends CommandExecutor> commandServiceClass) {
        if (commandServiceClass != null) {
            this.commandServiceClass = commandServiceClass;
            this.configProps.put("drools.commandService", commandServiceClass.getName());
        }
    }

    public void setTimerServiceClass(Class<? extends TimerService> timerServiceClass) {
        this.configProps.put("drools.timerService", timerServiceClass.getName());
    }

    public Class<? extends CommandExecutor> getCommandServiceClass() {
        return this.commandServiceClass;
    }

    public void setProcessInstanceManagerFactoryClass(String processInstanceManagerFactoryClass) {
        this.configProps.put("drools.processInstanceManagerFactory", processInstanceManagerFactoryClass);
    }

    public void setWorkItemManagerFactoryClass(Class<? extends WorkItemManagerFactory> workItemManagerFactoryClass) {
        if (workItemManagerFactoryClass != null) {
            this.workItemManagerFactoryClass = workItemManagerFactoryClass;
            this.configProps.put("drools.workItemManagerFactory", workItemManagerFactoryClass.getName());
        }
    }

    public Class<? extends WorkItemManagerFactory> getWorkItemManagerFactoryClass() {
        return this.workItemManagerFactoryClass;
    }

    public void setProcessSignalManagerFactoryClass(String processSignalManagerFactoryClass) {
        this.configProps.put("drools.processSignalManagerFactory", processSignalManagerFactoryClass);
    }
}

