/*
 * Decompiled with CFR 0.152.
 */
package org.kie.commons.java.nio.fs.file;

import java.io.File;
import org.kie.commons.java.nio.IOException;
import org.kie.commons.java.nio.file.FileStore;
import org.kie.commons.java.nio.file.Path;
import org.kie.commons.java.nio.file.attribute.BasicFileAttributeView;
import org.kie.commons.java.nio.file.attribute.FileAttributeView;
import org.kie.commons.java.nio.file.attribute.FileStoreAttributeView;
import org.kie.commons.validation.Preconditions;

public abstract class BaseSimpleFileStore
implements FileStore {
    BaseSimpleFileStore(Path path) {
    }

    BaseSimpleFileStore(File[] roots, Path path) {
    }

    public String type() {
        return null;
    }

    public boolean isReadOnly() {
        return false;
    }

    public boolean supportsFileAttributeView(Class<? extends FileAttributeView> type) {
        Preconditions.checkNotNull((String)"type", type);
        return type.equals(BasicFileAttributeView.class);
    }

    public boolean supportsFileAttributeView(String name) {
        Preconditions.checkNotEmpty((String)"name", (String)name);
        return name.equals("basic");
    }

    public <V extends FileStoreAttributeView> V getFileStoreAttributeView(Class<V> type) {
        Preconditions.checkNotNull((String)"type", type);
        return null;
    }

    public Object getAttribute(String attribute) throws UnsupportedOperationException, IOException {
        Preconditions.checkNotEmpty((String)"attribute", (String)attribute);
        if (attribute.equals("totalSpace")) {
            return this.getTotalSpace();
        }
        if (attribute.equals("usableSpace")) {
            return this.getUsableSpace();
        }
        if (attribute.equals("readOnly")) {
            return this.isReadOnly();
        }
        if (attribute.equals("name")) {
            return this.name();
        }
        throw new UnsupportedOperationException("Attribute '" + attribute + "' not available");
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof FileStore)) {
            return false;
        }
        FileStore ofs = (FileStore)o;
        return this.name().equals(ofs.name());
    }

    public int hashCode() {
        return this.name().hashCode();
    }
}

