/*
 * Decompiled with CFR 0.152.
 */
package org.kie.commons.java.nio.fs.file;

import java.io.File;
import org.kie.commons.java.nio.IOException;
import org.kie.commons.java.nio.base.AbstractBasicFileAttributeView;
import org.kie.commons.java.nio.base.BasicFileAttributesImpl;
import org.kie.commons.java.nio.base.FileTimeImpl;
import org.kie.commons.java.nio.base.LazyAttrLoader;
import org.kie.commons.java.nio.file.Path;
import org.kie.commons.java.nio.file.attribute.BasicFileAttributeView;
import org.kie.commons.java.nio.file.attribute.BasicFileAttributes;
import org.kie.commons.java.nio.file.attribute.FileTime;

public class SimpleBasicFileAttributeView
extends AbstractBasicFileAttributeView<Path> {
    private BasicFileAttributes attrs = null;

    public SimpleBasicFileAttributeView(Path path) {
        super(path);
    }

    public <T extends BasicFileAttributes> T readAttributes() throws IOException {
        if (this.attrs == null) {
            final File file = this.path.toFile();
            this.attrs = new BasicFileAttributesImpl(this.path.toString(), (FileTime)new FileTimeImpl(file.lastModified()), null, null, (LazyAttrLoader)new LazyAttrLoader<Long>(){
                private Long size = null;

                public Long get() {
                    if (this.size == null) {
                        this.size = file.length();
                    }
                    return this.size;
                }
            }, file.isFile(), file.isDirectory());
        }
        return (T)this.attrs;
    }

    public Class<? extends BasicFileAttributeView>[] viewTypes() {
        return new Class[]{BasicFileAttributeView.class, SimpleBasicFileAttributeView.class};
    }
}

