/*
 * Decompiled with CFR 0.152.
 */
package org.kie.commons.java.nio.fs.file;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import org.kie.commons.java.nio.IOException;
import org.kie.commons.java.nio.base.GeneralPathImpl;
import org.kie.commons.java.nio.file.FileSystem;
import org.kie.commons.java.nio.file.InvalidPathException;
import org.kie.commons.java.nio.file.Path;
import org.kie.commons.java.nio.file.PathMatcher;
import org.kie.commons.java.nio.file.WatchService;
import org.kie.commons.java.nio.file.attribute.UserPrincipalLookupService;
import org.kie.commons.java.nio.file.spi.FileSystemProvider;
import org.kie.commons.validation.PortablePreconditions;

public abstract class BaseSimpleFileSystem
implements FileSystem {
    private final FileSystemProvider provider;
    private final String defaultDirectory;
    private final Set<String> supportedFileAttributeViews;
    private final File[] roots;

    BaseSimpleFileSystem(FileSystemProvider provider, String path) {
        this(File.listRoots(), provider, path);
    }

    BaseSimpleFileSystem(File[] roots, FileSystemProvider provider, String path) {
        PortablePreconditions.checkNotNull((String)"roots", (Object)roots);
        PortablePreconditions.checkCondition((String)"should have at least one root", (roots.length > 0 ? 1 : 0) != 0);
        this.roots = roots;
        this.provider = provider;
        this.defaultDirectory = this.validateDefaultDir(path);
        this.supportedFileAttributeViews = Collections.unmodifiableSet(new HashSet<String>(){
            {
                this.add("basic");
            }
        });
    }

    private String validateDefaultDir(String path) throws IllegalArgumentException {
        PortablePreconditions.checkNotEmpty((String)"path", (String)path);
        if (!GeneralPathImpl.create((FileSystem)this, (String)path, (boolean)false).isAbsolute()) {
            throw new IllegalArgumentException();
        }
        return path;
    }

    public FileSystemProvider provider() {
        return this.provider;
    }

    public boolean isOpen() {
        return true;
    }

    public boolean isReadOnly() {
        return false;
    }

    public String getSeparator() {
        return System.getProperty("file.separator", "/");
    }

    public Set<String> supportedFileAttributeViews() {
        return this.supportedFileAttributeViews;
    }

    public Path getPath(String first, String ... more) throws InvalidPathException {
        if (more == null) {
            return GeneralPathImpl.create((FileSystem)this, (String)first, (boolean)false);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(first);
        for (String segment : more) {
            if (segment.length() <= 0) continue;
            if (sb.length() > 0) {
                sb.append(this.getSeparator());
            }
            sb.append(segment);
        }
        return GeneralPathImpl.create((FileSystem)this, (String)sb.toString(), (boolean)false);
    }

    public PathMatcher getPathMatcher(String syntaxAndPattern) throws IllegalArgumentException, PatternSyntaxException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public UserPrincipalLookupService getUserPrincipalLookupService() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public WatchService newWatchService() throws UnsupportedOperationException, IOException {
        throw new UnsupportedOperationException();
    }

    public void close() throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException("can't close this file system.");
    }

    File[] listRoots() {
        return this.roots;
    }
}

