/*
 * Decompiled with CFR 0.152.
 */
package org.kie.bc.backend;

import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.workbench.screens.workitems.backend.server.WorkbenchConfigurationHelper;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigItem;
import org.guvnor.structure.server.config.ConfigType;
import org.guvnor.structure.server.config.ConfigurationFactory;
import org.guvnor.structure.server.config.ConfigurationService;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.kie.workbench.screens.workbench.backend.BaseAppSetup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.services.cdi.ApplicationStarted;
import org.uberfire.commons.services.cdi.Startup;
import org.uberfire.commons.services.cdi.StartupType;
import org.uberfire.io.IOService;

@Startup(value=StartupType.BOOTSTRAP)
@ApplicationScoped
public class AppSetup
extends BaseAppSetup {
    private static final Logger logger = LoggerFactory.getLogger(AppSetup.class);
    private Event<ApplicationStarted> applicationStartedEvent;
    private WorkbenchConfigurationHelper workbenchConfigurationHelper;

    protected AppSetup() {
    }

    @Inject
    public AppSetup(@Named(value="ioStrategy") IOService ioService, RepositoryService repositoryService, OrganizationalUnitService organizationalUnitService, KieModuleService moduleService, ConfigurationService configurationService, ConfigurationFactory configurationFactory, Event<ApplicationStarted> applicationStartedEvent, WorkbenchConfigurationHelper workbenchConfigurationHelper) {
        super(ioService, repositoryService, organizationalUnitService, moduleService, configurationService, configurationFactory);
        this.applicationStartedEvent = applicationStartedEvent;
        this.workbenchConfigurationHelper = workbenchConfigurationHelper;
    }

    @PostConstruct
    public void init() {
        try {
            this.configurationService.startBatch();
            this.setupConfigurationGroup(ConfigType.GLOBAL, "settings", this.getGlobalConfiguration(), new ConfigItem[0]);
            this.setupConfigurationGroup(ConfigType.EDITOR, "work-items-editor-settings", this.workbenchConfigurationHelper.getWorkItemElementDefinitions(), new ConfigItem[0]);
            this.applicationStartedEvent.fire((Object)new ApplicationStarted());
        }
        catch (Exception e) {
            logger.error("Error during update config", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            this.configurationService.endBatch();
        }
    }

    protected ConfigGroup getGlobalConfiguration() {
        ConfigGroup group = this.configurationFactory.newConfigGroup(ConfigType.GLOBAL, "settings", "");
        group.addConfigItem(this.configurationFactory.newConfigItem("drools.dateformat", "dd-MMM-yyyy"));
        group.addConfigItem(this.configurationFactory.newConfigItem("drools.datetimeformat", "dd-MMM-yyyy HH:mm:ss"));
        group.addConfigItem(this.configurationFactory.newConfigItem("drools.defaultlanguage", "en"));
        group.addConfigItem(this.configurationFactory.newConfigItem("drools.defaultcountry", "US"));
        group.addConfigItem(this.configurationFactory.newConfigItem("build.enable-incremental", "true"));
        group.addConfigItem(this.configurationFactory.newConfigItem("rule-modeller-onlyShowDSLStatements", "false"));
        group.addConfigItem(this.configurationFactory.newConfigItem("designer.context", "designer"));
        group.addConfigItem(this.configurationFactory.newConfigItem("designer.profile", "jbpm"));
        group.addConfigItem(this.configurationFactory.newConfigItem("support.runtime.deploy", "true"));
        return group;
    }
}

