/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.client.resource;

import org.keycloak.authorization.client.representation.TokenIntrospectionResponse;
import org.keycloak.authorization.client.resource.PermissionResource;
import org.keycloak.authorization.client.resource.ProtectedResource;
import org.keycloak.authorization.client.util.Http;

public class ProtectionResource {
    private final String pat;
    private final Http http;

    public ProtectionResource(Http http, String pat) {
        if (pat == null) {
            throw new RuntimeException("No access token was provided when creating client for Protection API.");
        }
        this.http = http;
        this.pat = pat;
    }

    public ProtectedResource resource() {
        return new ProtectedResource(this.http, this.pat);
    }

    public PermissionResource permission() {
        return new PermissionResource(this.http, this.pat);
    }

    public TokenIntrospectionResponse introspectRequestingPartyToken(String rpt) {
        return this.http.post("/protocol/openid-connect/token/introspect").authentication().oauth2ClientCredentials().form().param("token_type_hint", "requesting_party_token").param("token", rpt).response().json(TokenIntrospectionResponse.class).execute();
    }
}

