/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.admin.ui.rest;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.keycloak.admin.ui.rest.model.UIRealmInfo;
import org.keycloak.admin.ui.rest.model.UIRealmRepresentation;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.StorageProviderRealmModel;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.userprofile.config.UPConfig;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.RealmAdminResource;
import org.keycloak.services.resources.admin.UserProfileResource;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.storage.CacheableStorageProviderModel;

public class UIRealmResource {
    private final RealmAdminResource delegate;
    private final KeycloakSession session;
    private final AdminPermissionEvaluator auth;
    private final AdminEventBuilder adminEvent;

    public UIRealmResource(KeycloakSession session, AdminPermissionEvaluator auth, AdminEventBuilder adminEvent) {
        this.session = session;
        this.auth = auth;
        this.adminEvent = adminEvent;
        this.delegate = new RealmAdminResource(session, auth, adminEvent);
    }

    @PUT
    @Consumes(value={"application/json"})
    @Operation(hidden=true)
    public Response updateRealm(UIRealmRepresentation rep) {
        Response response = this.delegate.updateRealm((RealmRepresentation)rep);
        if (this.isSuccessful(response)) {
            this.updateUserProfileConfiguration(rep);
        }
        return response;
    }

    @GET
    @Path(value="info")
    @Operation(summary="Gets information about the realm, viewable by all realm admins")
    @APIResponse(responseCode="200", description="", content={@Content(schema=@Schema(implementation=UIRealmInfo.class, type=SchemaType.OBJECT))})
    public UIRealmInfo getInfo() {
        this.auth.requireAnyAdminRole();
        UIRealmInfo info = new UIRealmInfo();
        info.setUserProfileProvidersEnabled(this.isAtLeastOneUserStorageProviderEnabled());
        return info;
    }

    private boolean isAtLeastOneUserStorageProviderEnabled() {
        return ((StorageProviderRealmModel)this.session.getContext().getRealm()).getUserStorageProvidersStream().anyMatch(CacheableStorageProviderModel::isEnabled);
    }

    private void updateUserProfileConfiguration(UIRealmRepresentation rep) {
        UPConfig upConfig = rep.getUpConfig();
        if (upConfig == null) {
            return;
        }
        UserProfileResource userProfileResource = new UserProfileResource(this.session, this.auth, this.adminEvent);
        if (!upConfig.equals((Object)userProfileResource.getConfiguration())) {
            Response response = userProfileResource.update(upConfig);
            if (this.isSuccessful(response)) {
                return;
            }
            throw new InternalServerErrorException("Failed to update user profile configuration");
        }
    }

    private boolean isSuccessful(Response response) {
        return Response.Status.Family.SUCCESSFUL.equals((Object)response.getStatusInfo().getFamily());
    }
}

