/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime;

import io.quarkus.runtime.ApplicationLifecycleManager;
import io.quarkus.runtime.Quarkus;
import io.quarkus.runtime.QuarkusApplication;
import io.quarkus.runtime.annotations.QuarkusMain;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.common.Version;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakTransactionManager;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.KeycloakClassLoader;
import org.keycloak.quarkus.runtime.Messages;
import org.keycloak.quarkus.runtime.cli.ExecutionExceptionHandler;
import org.keycloak.quarkus.runtime.cli.Picocli;
import org.keycloak.quarkus.runtime.cli.command.Start;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.managers.ApplianceBootstrap;
import org.keycloak.services.resources.KeycloakApplication;

@QuarkusMain(name="keycloak")
@ApplicationScoped
public class KeycloakMain
implements QuarkusApplication {
    private static final String KEYCLOAK_ADMIN_ENV_VAR = "KEYCLOAK_ADMIN";
    private static final String KEYCLOAK_ADMIN_PASSWORD_ENV_VAR = "KEYCLOAK_ADMIN_PASSWORD";

    public static void main(String[] args) {
        System.setProperty("kc.version", Version.VERSION);
        List<String> cliArgs = Picocli.parseArgs(args);
        if (cliArgs.isEmpty()) {
            cliArgs = new ArrayList<String>(cliArgs);
            cliArgs.add("-h");
        } else if (KeycloakMain.isFastStart(cliArgs)) {
            ExecutionExceptionHandler errorHandler = new ExecutionExceptionHandler();
            PrintWriter errStream = new PrintWriter(System.err, true);
            if (Start.isDevProfileNotAllowed(Arrays.asList(args))) {
                errorHandler.error(errStream, Messages.devProfileNotAllowedError("start"), null);
                return;
            }
            KeycloakMain.start(errorHandler, errStream, args);
            return;
        }
        Picocli.parseAndRun(cliArgs);
    }

    private static boolean isFastStart(List<String> cliArgs) {
        return cliArgs.size() == 2 && cliArgs.get(0).equals("start") && cliArgs.stream().anyMatch("--optimized"::equals);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start(ExecutionExceptionHandler errorHandler, PrintWriter errStream, String[] args) {
        ClassLoader originalCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(new KeycloakClassLoader());
            Quarkus.run(KeycloakMain.class, (exitCode, cause) -> {
                if (cause != null) {
                    errorHandler.error(errStream, String.format("Failed to start server in (%s) mode", Environment.getKeycloakModeFromProfile(Environment.getProfileOrDefault("prod"))), cause.getCause());
                }
                if (Environment.isDistribution()) {
                    System.exit(exitCode);
                }
            }, (String[])args);
        }
        catch (Throwable cause2) {
            errorHandler.error(errStream, String.format("Unexpected error when starting the server in (%s) mode", Environment.getKeycloakModeFromProfile(Environment.getProfileOrDefault("prod"))), cause2.getCause());
            System.exit(1);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCl);
        }
    }

    public int run(String ... args) throws Exception {
        if (!Environment.isImportExportMode()) {
            this.createAdminUser();
        }
        if (Environment.isDevProfile()) {
            Logger.getLogger(KeycloakMain.class).warnf("Running the server in development mode. DO NOT use this configuration in production.", new Object[0]);
        }
        int exitCode = ApplicationLifecycleManager.getExitCode();
        if (Environment.isTestLaunchMode() || Environment.isImportExportMode()) {
            Quarkus.asyncExit((int)exitCode);
        } else {
            Quarkus.waitForExit();
        }
        return exitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAdminUser() {
        String adminUserName = System.getenv(KEYCLOAK_ADMIN_ENV_VAR);
        String adminPassword = System.getenv(KEYCLOAK_ADMIN_PASSWORD_ENV_VAR);
        if (adminUserName == null || adminUserName.trim().length() == 0 || adminPassword == null || adminPassword.trim().length() == 0) {
            return;
        }
        KeycloakSessionFactory sessionFactory = KeycloakApplication.getSessionFactory();
        KeycloakSession session = sessionFactory.create();
        KeycloakTransactionManager transaction = session.getTransactionManager();
        try {
            transaction.begin();
            new ApplianceBootstrap(session).createMasterRealmUser(adminUserName, adminPassword);
            ServicesLogger.LOGGER.addUserSuccess(adminUserName, Config.getAdminRealm());
            transaction.commit();
        }
        catch (IllegalStateException e) {
            session.getTransactionManager().rollback();
            ServicesLogger.LOGGER.addUserFailedUserExists(adminUserName, Config.getAdminRealm());
        }
        catch (Throwable t) {
            session.getTransactionManager().rollback();
            ServicesLogger.LOGGER.addUserFailed(t, adminUserName, Config.getAdminRealm());
        }
        finally {
            session.close();
        }
    }
}

