/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.ldap.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.storage.ldap.model.LdapMapDn;

public class LdapMapObject
implements AbstractEntity {
    private static final Logger logger = Logger.getLogger(LdapMapObject.class);
    private String id;
    private LdapMapDn dn;
    private final List<String> rdnAttributeNames = new LinkedList<String>();
    private final List<String> objectClasses = new LinkedList<String>();
    private final List<String> readOnlyAttributeNames = new LinkedList<String>();
    private final Map<String, Set<String>> attributes = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> lowerCasedAttributes = new HashMap<String, Set<String>>();
    private final Map<String, Integer> rangedAttributes = new HashMap<String, Integer>();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public LdapMapDn getDn() {
        return this.dn;
    }

    public void setDn(LdapMapDn dn) {
        this.dn = dn;
    }

    public List<String> getObjectClasses() {
        return this.objectClasses;
    }

    public void setObjectClasses(Collection<String> objectClasses) {
        this.objectClasses.clear();
        this.objectClasses.addAll(objectClasses);
    }

    public List<String> getReadOnlyAttributeNames() {
        return this.readOnlyAttributeNames;
    }

    public void addReadOnlyAttributeName(String readOnlyAttribute) {
        this.readOnlyAttributeNames.add(readOnlyAttribute.toLowerCase());
    }

    public void removeReadOnlyAttributeName(String readOnlyAttribute) {
        this.readOnlyAttributeNames.remove(readOnlyAttribute.toLowerCase());
    }

    public List<String> getRdnAttributeNames() {
        return this.rdnAttributeNames;
    }

    public void setRdnAttributeName(String rdnAttributeName) {
        this.rdnAttributeNames.clear();
        this.rdnAttributeNames.add(rdnAttributeName);
    }

    public void setRdnAttributeNames(List<String> rdnAttributeNames) {
        this.rdnAttributeNames.clear();
        this.rdnAttributeNames.addAll(rdnAttributeNames);
    }

    public void addRdnAttributeName(String rdnAttributeName) {
        this.rdnAttributeNames.add(rdnAttributeName);
    }

    public void setSingleAttribute(String attributeName, String attributeValue) {
        LinkedHashSet<String> asSet = new LinkedHashSet<String>();
        asSet.add(attributeValue);
        this.setAttribute(attributeName, asSet);
    }

    public void setAttribute(String attributeName, Set<String> attributeValue) {
        this.attributes.put(attributeName, attributeValue);
        this.lowerCasedAttributes.put(attributeName.toLowerCase(), attributeValue);
    }

    public String getAttributeAsString(String name) {
        Set<String> attrValue = this.lowerCasedAttributes.get(name.toLowerCase());
        if (attrValue == null || attrValue.size() == 0) {
            return null;
        }
        if (attrValue.size() > 1) {
            logger.warnf("Expected String but attribute '%s' has more values '%s' on object '%s' . Returning just first value", (Object)name, attrValue, (Object)this.dn);
        }
        return attrValue.iterator().next();
    }

    public Set<String> getAttributeAsSet(String name) {
        Set<String> values = this.lowerCasedAttributes.get(name.toLowerCase());
        return values == null ? null : new LinkedHashSet<String>(values);
    }

    public boolean isRangeComplete(String name) {
        return !this.rangedAttributes.containsKey(name);
    }

    public int getCurrentRange(String name) {
        return this.rangedAttributes.get(name);
    }

    public boolean isRangeCompleteForAllAttributes() {
        return this.rangedAttributes.isEmpty();
    }

    public void addRangedAttribute(String name, int max) {
        Integer current = this.rangedAttributes.get(name);
        if (current == null || max > current) {
            this.rangedAttributes.put(name, max);
        }
    }

    public void populateRangedAttribute(LdapMapObject obj, String name) {
        Set<String> newValues = obj.getAttributes().get(name);
        if (newValues != null && this.attributes.containsKey(name)) {
            this.attributes.get(name).addAll(newValues);
            if (!obj.isRangeComplete(name)) {
                this.addRangedAttribute(name, obj.getCurrentRange(name));
            } else {
                this.rangedAttributes.remove(name);
            }
        }
    }

    public Map<String, Set<String>> getAttributes() {
        return this.attributes;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        LdapMapObject other = (LdapMapObject)obj;
        return this.getId() != null && other.getId() != null && this.getId().equals(other.getId());
    }

    public int hashCode() {
        int result = this.getId() != null ? this.getId().hashCode() : 0;
        result = 31 * result + (this.getId() != null ? this.getId().hashCode() : 0);
        return result;
    }

    public String toString() {
        return "LdapMapObject [ dn: " + this.dn + " , id: " + this.id + ", attributes: " + this.attributes + ", readOnly attribute names: " + this.readOnlyAttributeNames + ", ranges: " + this.rangedAttributes + " ]";
    }
}

